/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   The edit field header                            Luebeck               /
/                                                    Winter, 1996          \
\   (C++)								   /
/                                                                          \
\                                     Last revision :  12:22 12 Oct 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#ifndef Field_h
#define Field_h

#include	"reg.h"

#define         FIELD_SIZE      10

class Field
{
   static char  Text [FIELD_SIZE];  // Text buffer
   int          Value;              // The current value
   int          Min;                // Valid value
   int          Max;                // Valid value
   const char * Msg;                // Wrong value message
   HWND		Window;		    // The corresponding edit control

public:
   Field
   (  
      int           InitValue,      // Default
      int           MinValue,       // Range
      int           MaxValue,
      const char *  Message         // Error message      
   )
   {  // Constructor
      Min = MinValue;
      Max = MaxValue;
      Value = InitValue;
      Msg = Message;
   }
  ~Field () {}
   int Set (int New, int Update = 1);
   void OnInit (HWND EditControl, int InitValue)
   {  // Initialization
      Window = EditControl;
      Set (InitValue);
      wsprintf (Text, "%d", Value);
      SetWindowText (Window, Text);
   }
   operator int () const
   {  // Get value
      return Value;
   }
   const int Check ()
   {  // Check contents of an edit box
      Text [GetWindowText (Window, Text, FIELD_SIZE - 1)] = 0;
      Set (atoi (Text));
      return Value;
   }
}; // Field

#endif  /*> Field_h <*/
