/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   The Fix class                                    Luebeck               /
/                                                    Winter, 1996          \
\   (C++)                                                                  /
/                                                                          \
\                                     Last revision :  13:13 02 Mar 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#include	<windows.h>

#include	"fix.h"

void Fix::OnInit (HWND EditControl, const char * InitValue)
{  // Initialization
   int	Size;

   Window = EditControl;
   for
   (  Size = 0;
      (  Size < MAX_FIX_LENGTH
      && 0 != (Text [Size] = InitValue [Size])
      );
      Size++
   );
   Text [Size] = 0;
   Length = Size;
   Check (1);

}  // Fix::OnInit
//
// IsPrefix -- Matching against the head of a string
//
//      String  - Points to the string
//      Offset  - The first string position (0..)
//
// The prefix must be separated by at least  one  blank  character.  The
// offset  is  reset  to point to the first string position containing a
// non-blank character, perhabs after the recognized prefix.
//
// Returns :
//
//      [0]  It is a prefix of the string
//      [1]  Otherwise
//
int Fix::IsPrefix (const char * String, int& Offset)
{
   int  Index;
   char Byte;

   Offset = 0;
   while ((Byte = *String++) == SP || Byte == HT || Byte == CR)
   {  // Skip forwarding spaces (CR as well)
      Offset++;
   }
   for (  Index = 0;
          Index < Length && Byte == Text [Index];
          Byte = *String++
       )  Index++;
   if (  Index < Length
      || (  Byte != 0
         && Byte != SP
         && Byte != HT
         && Byte != NL
         && Byte != CR
      )  )  return 0;
   Offset += Length;
   while (Byte == SP || Byte == HT || Byte == CR)
   {  // Skip trailing spaces (CR as well)
      Offset++;
      Byte = *String++;
   }
   return 1;

}  // Fix::IsPrefix
//
// IsSuffix -- Matching against the tail of a string
//
//      String          - Points to the string
//      SuffixLength    - The suffix length (return value)
//      StringLength    - The line length
//
// The suffix must be separated by at least  one  blank  character.  The
// returned SuffixLength indicates how  long  the  string  tail  is.  It
// includes possibly recognized suffix and surrounding blank characters.
// The StringLength parameter may  be  negative  to  indicate  that  the
// actual  string length is unknown. In this case the string length will
// be computed.                                                          
//
// Returns :
//
//      [0]  It is a suffix of the string
//      [1]  Otherwise
//
int Fix::IsSuffix
(
   const char * String,
   int&         SuffixLength,
   int&         StringLength
)
{
   int  Index;
   char Byte;

   if (StringLength < 0)
   {  // The string length is unknown yet
      for (Index = 0; 0 != (Byte = *String++) && NL != Byte; Index++);
      --String;
      StringLength = Index;
   }
   else
   {  // The string length is provided
      Index = StringLength;
      String += Index;
   }
   while (  Index
         && (  SP == (Byte = *--String)
            || HT == Byte
            || CR == Byte
         )  )  --Index;
   SuffixLength = StringLength - Index;
   if (Length == 0 || Index < Length) return 0;
   for (  Index = Length - 1;
          Index >= 0 && Byte == Text [Index];
          Byte = *--String
       )  --Index;          // Match the suffix
   if (  Index >= 0
      || (  SuffixLength == Length
         && Byte != SP
         && Byte != HT
         && Byte != NL
         && Byte != CR
      )  ) return 0;
   Index = StringLength - SuffixLength - Length;
   while (  Index
         && (  SP == (Byte = *--String)
            || HT == Byte
            || CR == Byte
         )  )  --Index;
   SuffixLength = StringLength - Index;
   return 1;

}  // Fix::IsSuffix
//
// Fix::Check -- Remove bad characters form the text
//
void Fix::Check (int Show)
{
   int	Index, From, To;

   Length = To = strlen (Text);
   while (To)
   {  // Scan the text
      switch (Text [--To])
      {  // Wrong characters to be substituted for space
         case CR :
         case HT :
         case NL :
            Text [To] = SP;
            Show |= 1;
   }  }
   for (From = 0; From < Length && Text [From] == SP; From++);
   if (From == Length)
   {  // Only spaces
      Show |= (Length != 0);
      Length = 0;
   }
   else
   {  // Trim spaces
      for (To = Length - 1; Text [To] == SP; --To);
      Index = To - From + 1;
      Show |= (Index != Length);
      Length = Index;
      if (From)
      {  // Move the string left
         for (Index = 0; From <= To; Text [Index++] = Text [From++]);
   }  }
   Text [Length] = 0;
   if (Show) SetWindowText (Window, Text);

}  // Fix::Check
