/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   Formatting the clipboard                         Luebeck               /
/                                                    Winter, 1994          \
\   (C++)								   /
/									   \
\                                     Last revision :  13:13 02 Mar 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#include    "clipman.h"
#include    "buffer.h"

const char * const  StrCRLF  = "\r\n";
const char * const  StrMinus = "-";
const char * const  StrNull  = "";
//
// GetBlank -- Skips blank space
//
//	Text	    - The string
//	Pointer	    - The string position to start with (0..)
//	Position    - The string position with expanded spaces (0..)
//
static void GetBlank (const char * Text, int& Pointer, int& Position)
{  // Skip blank space and get expanded offset
   Text += Pointer;
   for (;;)
   {  // Here is a character
      switch (*Text++)
      {  
         case SP :  // Space character
	    Position++;
	    Pointer++;
            continue;
	 case HT :  // Tabulation - expanding
	    Pointer++;
	    Position = ((Position + (int) TabEdit) / TabEdit) * TabEdit;
            continue;
         default :  // Other
	    return;
   }  }
}  // GetBlank

int Format ()
{  // Formatting the clipboard contents
   if (!GetClipboard ()) return 0;
   try
   {  // Begin formatting the clipboard contents
      CharArray	Pool;
      GlobalStr	Update;				// New clipboard contents
      char   	Hyphen		= 0;
      char   	Byte;
      int    	BufLen		= 0;
      int    	BufPtr		= 0;
      int    	BufWords	= 0;
      int    	BufWrap		= MarginEdit;
      int	Extra;
      int    	Fill;
      int    	Glue		= 0;
      int	LineLen		= 2147483647;
      int	PrefNo;
      int    	SecondAftPref	= 0;
      int    	SecondWrap	= MarginEdit;
      int	SecondPrefNo;
      int    	Skip		= 0;
      int	SkipForPref	= 0;
      int	SkipAftPref	= 0;
      int	SkipForSuff;
      int	SuffLen		= -1;
      int    	WordBeg;
      int    	WordEnd;
      int    	WordGap;

      GetBlank (Board.Text, Skip, SkipAftPref);
      for (PrefNo = 0; PrefNo < FIX_NUMBER; PrefNo++)
      {  // For each prefix
	 if (Prefix [PrefNo].IsPrefix (Board.Text, Extra)) break;
      }
      if (PrefNo != FIX_NUMBER)
      {  // Here is a prefix found
	 Skip += Prefix [PrefNo].Length;
	 SkipForPref = SkipAftPref;
	 SkipAftPref += Prefix [PrefNo].Length;
         GetBlank (Board.Text, Skip, SkipAftPref);
         SkipAftPref -= SkipForPref + Prefix [PrefNo].Length;
         LineLen = -1;
	 Postfix [PrefNo].IsSuffix (&Board.Text [Skip], SuffLen, LineLen);
	 LineLen += Skip;
	 Extra = LineLen;
	 LineLen -= SuffLen;
      }
      else
      {  // There is no prefix - find the line length
	 Extra = Skip;
	 while (0 != (Byte = Board.Text [Extra]) && NL != Byte)
	 {  // To the end of the first line
	    Extra++;
      }  }
      SecondPrefNo = PrefNo;
      if (NL == Board.Text [Extra++])
      {  // The second line is here
	 // WordBeg = Extra;
	 SecondAftPref = 0;
         GetBlank (Board.Text, Extra, SecondAftPref);
	 if (  PrefNo != FIX_NUMBER
	    && Prefix [PrefNo].IsPrefix (&Board.Text [Extra], Fill)
	    )
	 {  // Here is the prefix
            Extra += Prefix [PrefNo].Length;
	    SecondAftPref += Prefix [PrefNo].Length;
	    GetBlank (Board.Text, Extra, SecondAftPref);
	    SecondAftPref -= SkipForPref + Prefix [PrefNo].Length;
	 }
	 SkipForSuff = SkipAftPref;
         if (SkipAftPref < SecondAftPref)
         {  // The 1st margin is less than the second one
  	    Extra   = 0;
	    WordGap = Skip;
	    WordEnd = SkipAftPref;
	    for (;;)
	    {
	       switch (Board.Text [Skip])
	       {
	  	  case SP :
		  case HT :
		     Extra++;
		     WordGap = Skip;
		     WordEnd = SkipAftPref;
		     GetBlank (Board.Text, Skip, SkipAftPref);
		     if (SkipAftPref < SecondAftPref) continue;
		     SkipAftPref = WordEnd;
		     Skip = WordGap;
		     break;
		  case CR :
		  case NL :
		  case 0  :
		     Extra++;
		     break;
		  default :
		     Skip++;
		     SkipAftPref++;
		     if (SkipAftPref < SecondAftPref) continue;
		     SkipAftPref = WordEnd;
		     Skip = WordGap;
		     break;
	       }
	       break;
	    }
	    if (Extra)
	    {  // There is the hanging text - no formatting
	       Update.Put (Board.Text, Skip);
	       BufWrap -= SkipAftPref;// - Prefix [SecondPrefNo].Length;
	       SkipAftPref = SecondAftPref - SkipAftPref;
	       PrefNo = FIX_NUMBER;
	 }  }
	 else
	 {  // The second margin is less than the first one
	    SkipForSuff = SecondAftPref;
      }  }
      else
      {  // There is no second line
         SecondAftPref = SkipAftPref;
	 SkipForSuff = SkipAftPref;
      }
      Board.Text += Skip;
      LineLen -= Skip;
      if (SecondPrefNo != FIX_NUMBER)
      {  // Here is a prefix
	 if (0 == Postfix [SecondPrefNo].Length) SkipForSuff = 0;
	 BufWrap -=
	    (  SkipForPref
	    +  Prefix [SecondPrefNo].Length
	    +  SkipForSuff
            +  Postfix [SecondPrefNo].Length
	    );
         SecondWrap -=
	    (  SkipForPref
	    +  Prefix [SecondPrefNo].Length
	    +  SkipForSuff
            +  Postfix [SecondPrefNo].Length
	    );
      }
      if (  SkipAftPref >= BufWrap
         || SecondAftPref >= SecondWrap
         )
      {  // Wrong pattern
         Error (PatternMessage);
	 PutClipboard ();
         return 0;
      }
      do
      {
	 if (LineLen)
	 {  // Get the current character
            Hyphen = Byte;	// Store the previous character
            Byte = *Board.Text++;
	    --LineLen;
	 }
	 else
	 {  // Simulate end of the line
	    Byte = 0;
	 }
         switch (Byte)
         {  // Analyzing the current character
	    case 0  :  // End of the line
	       Board.Text += SuffLen;	// To the line end
	       Byte = *Board.Text++;	// The actual terminator
  	    case NL :  // End of the line
	       if (SecondPrefNo != FIX_NUMBER)
	       {  // Skip the prefix
                  Prefix [SecondPrefNo].IsPrefix (Board.Text, LineLen);
	          Board.Text += LineLen;
		  LineLen = -1;
                  Postfix [SecondPrefNo].IsSuffix (Board.Text, SuffLen, LineLen);
		  LineLen -= SuffLen;
	       }
	       else
	       {  // Unlimited line
		  SuffLen = -1;
	          LineLen = 2147483647;
	       }
	    case CR :
	       if (Hyphen == '-')
	       {  // The prevous character was the hyphen
	  	  Glue = 1;
		  continue;
	       }
	    case HT :
	    case SP :  // End of a word is here
	       if (  !Glue
	          && BufLen != BufPtr
		  && Pool [BufPtr - 1] != SP
		  )
	       {  // Place the word end
		  BufLen = BufPtr;
		  Pool [BufPtr++] = SP;
		  BufWords++;
	       }
	       continue;
	    default :  // Ordinal character is here
	       if (Glue)
	       {
	  	  --BufPtr;
		  Glue = 0;
	       }
	       Pool [BufPtr] = Byte;
	       if (BufPtr++ < BufWrap - SkipAftPref) continue;
	 }
      //
      // Forming a new line
      //
	 if (PrefNo != FIX_NUMBER)
	 {  // Here is the prefix
	    Update.Fill (SkipForPref);
	    Update.Put (Prefix [PrefNo].Text, Prefix [PrefNo].Length);
	 }
	 // PrefNo = SecondPrefNo;
	 Update.Fill (SkipAftPref);
      //
      // The line body
      //
	 if (--BufWords)
	 {  // Several words
	    Extra   = BufWrap - SkipAftPref - BufLen + BufWords;
	    WordGap = Extra / BufWords;
	    Skip    = Extra & 1;
	    Extra  %= BufWords;
	    Skip    = Skip ? BufWords - Extra : 0;

	    for (WordBeg = 0; WordBeg < BufLen; WordBeg = WordEnd + 1)
	    {  // For each word in the Pool
	       WordEnd = WordBeg;
	       while (WordEnd < BufLen && Pool [WordEnd] != SP)
	       {  // Looking for the word end
	  	  WordEnd++;
	       }
	       Update.Put (&Pool [WordBeg], WordEnd - WordBeg);
	       if (0 <= --BufWords)
	       {  // One more word, make spacing
		  Update.Fill (WordGap + (!Skip && Extra));
		  if (Skip)
		  {  // Use standard word gap
		     --Skip;
		  }
		  else
		  {  // Use standard word gap plus one space
		     if (Extra) --Extra;
         }  }  }  }
         else
         {  // Only one word per line
            if (BufLen == 0 || BufLen > BufWrap - SkipAftPref)
	    {  // Split this word
	       BufLen = BufWrap - SkipAftPref - 1;
	       Update.Put (&Pool [0], BufLen--);
	       Update.Put (StrMinus, 1);
	    }
	    else
	    {  // Write the whole word
	       Update.Put (&Pool [0], BufLen);
	       if (  SecondPrefNo != FIX_NUMBER
		  && Postfix [SecondPrefNo].Length
		  )
	       {  // Here is the suffix
	          Update.Fill (BufWrap - BufLen - SkipAftPref);
         }  }  }
         PrefNo = SecondPrefNo; 
	 if (PrefNo != FIX_NUMBER && Postfix [PrefNo].Length)
	 {  // Here is the suffix
	    Update.Fill (SkipForSuff);
	    Update.Put  (Postfix [PrefNo].Text, Postfix [PrefNo].Length);
	 }
         Update.Put (StrCRLF, 2);
         SkipAftPref = SecondAftPref;
         BufWrap = SecondWrap;
         if (BufPtr > BufLen)
         {
	    BufLen++;
	    strncpy (&Pool [0], &Pool [BufLen], BufPtr - BufLen);
	    BufPtr -= BufLen;
         }
         else
         {
	    BufPtr = 0;
         }
         BufLen   = 0;
         BufWords = 0;
      }  while (Byte);
      if (BufPtr)
      {  // Flush the rest of the buffer
	 if (PrefNo != FIX_NUMBER)
	 {  // Here is the prefix
	    Update.Fill (SkipForPref);
	    Update.Put  (Prefix [PrefNo].Text, Prefix [PrefNo].Length);
	 }
	 PrefNo = SecondPrefNo;
	 Update.Fill (SkipAftPref);
         Update.Put (&Pool [0], BufPtr);
	 if (PrefNo != FIX_NUMBER && Postfix [PrefNo].Length)
	 {  // Here is the suffix
	    Update.Fill (BufWrap - BufPtr - SkipAftPref + SkipForSuff);
	    Update.Put  (Postfix [PrefNo].Text, Postfix [PrefNo].Length);
      }  }
      Update.Put (StrNull, 1);	// Flushing the local buffer
      PutClipboard (Update.Export ());
   }
   catch (MemError& Reason)
   {  // Memory allocation errors
      Error (Reason.Text);
      PutClipboard ();
   }
   return 1;

}  // End of Dialog::Format
