/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   The Registry class                               Luebeck               /
/                                                    Summer, 1997          \
\   (C++)			                                           /
/   									   \
\                                     Last revision :  21:43 20 Jan 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#include	<windows.h>
#include	"reg.h"

Registry::Registry ()
{  // Constructor
   DWORD	Dummy;

   RegCreateKeyEx
   (  HKEY_CURRENT_USER,
      "Software\\Dmitry\\Clipman\\3.0",
      0,
      "",
      REG_OPTION_NON_VOLATILE,
      KEY_ALL_ACCESS,
      0,
      &Key,
      &Dummy
   );
   if (!GetInt ("Initialised"))
   {  // Initialise the registry
      PutInt ("Initialised", 1);
      PutInt ("Margin", 72);
      PutInt ("Tab", 8);
      PutString ("Prefix1", "//"); PutString ("Postfix1", ""  );
      PutString ("Prefix2", "/*"); PutString ("Postfix2", "*/");
      PutString ("Prefix3", "--"); PutString ("Postfix3", ""  );
      PutString ("Prefix4", ""  ); PutString ("Postfix4", ""  );
   }
}  // Registry::Registry

int Registry::GetInt (const char * Name, int Default)
{
   DWORD	Type;
   DWORD	Value;
   DWORD	Size;

   Size = sizeof (DWORD);
   if (  (  ERROR_SUCCESS
         != RegQueryValueEx
            (  Key,
               Name,
	       0,
	       &Type,
               (unsigned char *) &Value,
	       &Size
         )  )
      || Type != REG_DWORD
      || Size != sizeof (DWORD)
      )  return Default;
   return (int) Value;
   
}  // Registry::GetInt

void Registry::PutInt (const char * Name, int Value)
{
   DWORD	Data = Value;

   RegSetValueEx
   (  Key,
      Name,  
      0,
      REG_DWORD,
      (unsigned char *) &Data,
      sizeof (DWORD)
   );	
}  // Registry::PutInt

void Registry::GetString (const char * Name, char * String, int MaxSize)
{
   DWORD	Type;
   DWORD	Size;

   Size = MaxSize;
   if (  (  ERROR_SUCCESS
         != RegQueryValueEx
            (  Key,
               Name,
	       0,
	       &Type,
               (unsigned char *) String,
	       &Size
         )  )
      || Type != REG_SZ
      )
   {  // Error reading the string
      String [0] = 0;
   }
}  // Registry::GetString

void Registry::PutString (const char * Name, const char * String)
{
   RegSetValueEx
   (  Key,
      Name,  
      0,
      REG_SZ,
      (unsigned char *) String,
      strlen (String) + 1
   );	
}  // Registry::PutString