/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   Sorting the clipboard                            Luebeck               /
/                                                    Winter, 1994          \
\   (C++)								   /
/									   \
\                                     Last revision :  11:06 26 Jan 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#include    "clipman.h"
#include    "buffer.h"

const char * const  StrCRLF  = "\r\n";
const char * const  StrNull  = "";

int Sort ()
{  // Sorting the clipboard contents
   if (!GetClipboard ()) return 0;
   try
   {  // Begin sorting the clipboard contents
      IntArray	Pool;
      GlobalStr	Update;
      int    	LineBeg   = 0;
      int    	LineCount = 0;
      int    	Position, Index1, Index2, Tab1, Tab2;
      int    	Low, Focus, High;
      char   	Symbol1, Symbol2;

      for (; Board.Text [LineBeg]; LineCount++)
      {  // For each line from the clipboard
         Low   = 0;
         Focus = LineCount >> 1;
         High  = LineCount;
         while (Low < High)
         {
  	    Index1 = LineBeg;
	    Tab1   = 0;
	    Index2 = Pool [Focus];
	    Tab2   = 0;
	    for (Position = 0;; Position++)
	    {
	       if (Tab1)
	       {
	  	  --Tab1;
	       }
	       else
	       {
	 	  switch (Symbol1 = Board.Text [Index1++])
		  {
		     case HT :
			Symbol1 = SP;
			Tab1 =
			   (  (int) TabEdit
			   -  1
			   -  Position % TabEdit
			   );
			break;
		     case CR :
		     case NL :
		        Symbol1 = 0;
		     default :
		        break;
	       }  }
	       if (Tab2)
	       {
	 	  --Tab2;
	       }
	       else
	       {
		  switch (Symbol2 = Board.Text [Index2++])
		  {
		     case HT :
		        Symbol2 = SP;
			Tab2 =
			   (  (int) TabEdit
			   -  1
			   -  Position % TabEdit
			   );
			break;
		     case CR :
		     case NL :
		        Symbol2 = 0;
		     default :
		        break;
	       }  }
	       if (Symbol1 > Symbol2)
	       {
	  	  Low   = Focus + 1;
		  Focus = (Low + High) >> 1;
		  break;
	       }
	       if (Symbol1 < Symbol2)
	       {
		  High  = Focus;
		  Focus = (Low + High) >> 1;
		  break;
	       }
	       if (Symbol1 == 0)
	       {
		  Low   = High;
		  Focus = High;
		  break;
         }  }  }
         if (Focus != LineCount)
         {
	    memmove
	    (  &Pool [Focus + 1],
	       &Pool [Focus],
	       sizeof (int) * (LineCount - Focus)
	    );
	 }
	 Pool [Focus] = LineBeg;
	 while (Board.Text [LineBeg] && NL != Board.Text [LineBeg++]);
      }
      Low = LineCount;
      while (Low)
      {  // For each sorted line
         Focus = Pool [--Low];
	 for (;;)
	 {  // Determine its length
	    switch (Board.Text [Focus++])
	    {
	       case 0  :
	       case CR :
	       case NL : break;
	       default : continue;
	    }
	    break;
      }  }
      Position = 0;
      while (Position < LineCount)
      {  // For each line in the sorted lines list
         Focus = Pool [Position];
         for (;;)
         {  // Search for the line end
  	    switch (Board.Text [Focus++])
	    {
	       case 0  :
	       case CR :
	       case NL : --Focus; break;
	       default : continue;
	    }
	    break;
	 }
	 if (0 < (Focus -= Pool [Position]))
         {
  	    Update.Put (&Board.Text [Pool [Position]], Focus);
	 }
	 if (LineCount > ++Position)
	 {  // New line separator
	    Update.Put (StrCRLF, 2);
      }  }
      Update.Put (StrNull, 1);	// Flush the local buffer
      PutClipboard (Update.Export ());
   }
   catch (MemError& Reason)
   {  // Memory allocation errors
      Error (Reason.Text);
      PutClipboard ();
   }
   return 1;

}  // Dialog::Sort
