/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   The TaskBarIcon class                            Luebeck               /
/                                                    Summer, 1997          \
\   (C++)								   /
/                                                                          \
\                                     Last revision :  12:22 12 Oct 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#include	<windows.h>
#include	"clipman.h"
#include	"taskbar.h"

NOTIFYICONDATA  TaskBarIcon::Data;

void TaskBarIcon::Set (UINT MyState)
{  // Fill the NOTIFYICONDATA structure in
   Data.cbSize = sizeof (NOTIFYICONDATA);
   Data.hWnd = TheWindow;
   Data.uID = ID;
   Data.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP; 
   Data.uCallbackMessage = WM_TASK_BAR_NOTIFY;
   switch (State = MyState)
   {  // Set icon and tip according to the new state
      case Format_BUT :
         Data.hIcon = Icon.Format;
         lstrcpyn (Data.szTip, "Format", sizeof (Data.szTip));
         break;
      case Off_BUT :
         Data.hIcon = Icon.Off;
         lstrcpyn (Data.szTip, "Turn off", sizeof (Data.szTip));
         break;
      case Sort_BUT :
         Data.hIcon = Icon.Sort;
         lstrcpyn (Data.szTip, "Sort", sizeof (Data.szTip));
         break;
   }
}  // TaskBarIcon::Set

void TaskBarIcon::Hide ()
{  // Hide taskbar icon
   if (IsShown)
   {
      Data.cbSize = sizeof (NOTIFYICONDATA); 
      Data.hWnd = TheWindow; 
      Data.uID = ID;             
      Shell_NotifyIcon (NIM_DELETE, &Data);
      IsShown = 0;
   }
}  // TaskBarIcon::Hide
