/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*\
\                                                                          /
/   Clipboard manager                 Copyright (c)  Dmitry A. Kazakov     \
\   Header file for class                            Luebeck               /
/   TaskBarIcon					     Summer, 1997          \
\			                                                   /
/   (C++)								   \
\                                     Last revision :  12:22 12 Oct 1997   /
/                                                                          \
\   This program is free software; you can redistribute it and/or modify   /
/   it under the terms of the GNU General Public License as published by   \
\   the Free Software Foundation; either version 2 of  the  License,  or   /
/   (at your option) any later version.                                    \
\                                                                          /
/   This program is distributed in the hope that it will be useful,  but   \
\   WITHOUT  ANY WARRANTY; without even the implied warranty of MERCHAN-   /
/   TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See  the  GNU  General   \
\   Public License for more details.                                       /
/                                                                          \
\   You should have received a copy of the GNU  General  Public  License   /
/   along  with this program; if not, write to the Free Software Founda-   \
\   tion, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                    /
/                                                                          \
\*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/*/

#ifndef	TaskBar_h
#define	TaskBar_h

#define	    WM_TASK_BAR_NOTIFY  (WM_USER + 1)
/*>

   The TaskBarIcon class represents an icon in the Windows taskbar.  The
   constructor does not show any icon,  but defines  the  identifier  of
   the icon. Then the icon can be shown or hidden using  Show  and  Hide
   methods.  The  Show  method changes the icon appearance if necessary.
   The GetID method gives the Windows  identifier  associated  with  the
   icon.  The  `to  UINT'  conversion gives the current icon state, i.e.
   which of three possible buttons is shown as the icon. Possible values
   are {Off|Format|Sort}_BUT. 

<*/
class TaskBarIcon
{
private :
   static NOTIFYICONDATA    Data;	// Taskbar control data
   UINT			    ID;		// Icon identifier
   UINT			    State;	// Button shown as the icon
   int			    IsShown;	// In the taskbar

   void Set (UINT MyState);		// Reset the Data structure

public :
   TaskBarIcon (UINT MyID) { ID = MyID; IsShown = 0; }
   operator UINT () const { return State; }
   UINT GetID () { return ID; }
   void Hide ();
   void Show (UINT MyState)
   {  // Show taskbar icon
      Set (MyState);   
      Shell_NotifyIcon (IsShown ? NIM_MODIFY : NIM_ADD, &Data); 
      IsShown = 1;
   }
  ~TaskBarIcon () { Hide (); }

}; // End of TaskBarIcon

#endif	/*> TaskBar_h <*/
