#ifndef __MINIBUF_P_H__
#define __MINIBUF_P_H__

extern Lisp_Object read_minibuf _P_((Lisp_Object map, Lisp_Object initial,
                                     Lisp_Object prompt, Lisp_Object backup_n,
                                     int expflag, Lisp_Object histvar,
                                     Lisp_Object histpos));
extern Lisp_Object get_minibuffer _P_((int depth));
extern Lisp_Object read_minibuf_unwind _P_((Lisp_Object data));
extern int scmp _P_((register char *s1, register char *s2, int len));
extern _VOID_ temp_echo_area_glyphs _P_((char *m));
extern int do_completion _P_((void));
extern Lisp_Object assoc_for_completion _P_((register Lisp_Object key,
                                             Lisp_Object list));
extern _VOID_ init_minibuf_once _P_((void));
extern _VOID_ syms_of_minibuf _P_((void));
extern _VOID_ keys_of_minibuf _P_((void));
    
DEFUN_P(Fread_from_minibuffer, (Lisp_Object prompt, Lisp_Object initial_input,
                                Lisp_Object keymap, Lisp_Object read,
                                Lisp_Object hist));
DEFUN_P(Fread_minibuffer, (Lisp_Object prompt, Lisp_Object initial_contents));
DEFUN_P(Feval_minibuffer, (Lisp_Object prompt, Lisp_Object initial_contents));
DEFUN_P(Fread_string, (Lisp_Object prompt, Lisp_Object initial_input));
DEFUN_P(Fread_no_blanks_input, (Lisp_Object prompt, Lisp_Object initial));
DEFUN_P(Fread_command, (Lisp_Object prompt));
DEFUN_P(Fread_function, (Lisp_Object prompt));
DEFUN_P(Fread_variable, (Lisp_Object prompt));
DEFUN_P(Fread_buffer, (Lisp_Object prompt, Lisp_Object def,
                       Lisp_Object require_match));
DEFUN_P(Ftry_completion, (Lisp_Object string, Lisp_Object alist,
                          Lisp_Object pred));
DEFUN_P(Fall_completions, (Lisp_Object string, Lisp_Object alist,
                           Lisp_Object pred));
DEFUN_P(Fcompleting_read, (Lisp_Object prompt, Lisp_Object table,
                           Lisp_Object pred, Lisp_Object require_match,
                           Lisp_Object init, Lisp_Object hist));
DEFUN_P(Fminibuffer_complete, (void));
DEFUN_P(Fminibuffer_complete_and_exit, (void));
DEFUN_P(Fminibuffer_complete_word, (void));
DEFUN_P(Fdisplay_completion_list, (Lisp_Object completions));
DEFUN_P(Fminibuffer_completion_help, (void));
DEFUN_P(Fself_insert_and_exit, (void));
DEFUN_P(Fexit_minibuffer, (void));
DEFUN_P(Fminibuffer_depth, (void));
    
#endif
