/*
 ******************************************************************************
 ******************************************************************************
 *
 *  Licensed Materials - Property of IBM
 *
 *  IBM TCP/IP for DOS.
 *  Copyright (c) IBM Corp. 1992.  All rights reserved.
 *  US Government Users Restricted Rights - Use, duplication or
 *  disclosure restricted by GSA ADP Schedule contract with IBM Corp.
 *
 ******************************************************************************
 ******************************************************************************
 *
 *  $Author:   Build_Coordinator  $
 *  $Revision:   1.9  $
 *  $Modtime:   07 Jan 1993 09:37:10  $
 *
 *  $Header:   L:/INCLUDE/RSA/SYS/SOCKET.H_V   1.9   07 Jan 1993 09:37:32   Build_Coordinator  $
 *
 *  $Log:   L:/INCLUDE/RSA/SYS/SOCKET.H_V  $
 * 
 *    Rev 1.9   07 Jan 1993 09:37:32   Build_Coordinator
 * Add __loadds to prototype of asyncselect to remind users that they should 
 * use this on their callback routines.
 *
 *    Rev 1.8   07 Jan 1993 09:35:24   Build_Coordinator
 * Add MSC V6.0 support for the __loadds keyword.
 *
 *    Rev 1.7   01 Jan 1993 16:58:40   Build_Coordinator
 * Define __pascal and __far for users of compilers other than MSC70.
 *
 *    Rev 1.6   26 Dec 1992 16:07:56   Build_Coordinator
 * Add support for gethostname()
 *
 *    Rev 1.5   13 Dec 1992 09:30:52   Build_Coordinator
 * Bracket socket.h in a #ifndef #endif pair to prevent redefinitions.
 *
 *    Rev 1.4   04 Dec 1992 11:36:24   Jonathan_Rosen
 * - Modified the prototype for asyncselect() to force the compilier
 *   to check that the callback rtn is of the right attributes and number
 *   of parameters.
 * - Added prototypes for timeout() and untimeout() routines.
 *
 *    Rev 1.3   05 Nov 1992 10:36:28   Jonathan_Rosen
 * - Added new parameter to asyncselect().
 *
 *    Rev 1.2   06 Oct 1992 14:06:28   Build_Coordinator
 * Got rid of a mistake on the header.
 *
 *    Rev 1.1   06 Oct 1992 13:02:34   Build_Coordinator
 * Standardized the file headers.
 *
 *    Rev 1.0   01 Sep 1992 16:11:40   Jonathan_Rosen
 * Initial revision.
 *
 ******************************************************************************
 ******************************************************************************
 */

/*
 * Copyright (c) 1982,1985,1986,1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)socket.h    7.13 (Berkeley) 4/20/91
 */
#ifndef _SOCKETS_
#define _SOCKETS_

/*
 * Definitions related to sockets: types, address families, options.
 */

#ifndef __pascal
#define __pascal _pascal
#endif
#ifndef __far
#define __far _far
#endif
#ifndef __loadds
#define __loadds _loadds
#endif


/*
 * Types
 */
#define SOCK_STREAM     1               /* stream socket */
#define SOCK_DGRAM      2               /* datagram socket */
#define SOCK_RAW        3               /* raw-protocol interface */
#define SOCK_RDM        4               /* reliably-delivered message */
#define SOCK_SEQPACKET  5               /* sequenced packet stream */

/*
 * Option flags per-socket.
 */
#define SO_DEBUG        0x0001          /* turn on debugging info recording */
#define SO_ACCEPTCONN   0x0002          /* socket has had listen() */
#define SO_REUSEADDR    0x0004          /* allow local address reuse */
#define SO_KEEPALIVE    0x0008          /* keep connections alive */
#define SO_DONTROUTE    0x0010          /* just use interface addresses */
#define SO_BROADCAST    0x0020          /* permit sending of broadcast msgs */
#define SO_USELOOPBACK  0x0040          /* bypass hardware when possible */
#define SO_LINGER       0x0080          /* linger on close if data present */
#define SO_OOBINLINE    0x0100          /* leave received OOB data in line */

/*
 * Additional options, not kept in so_options.
 */
#define SO_SNDBUF       0x1001          /* send buffer size */
#define SO_RCVBUF       0x1002          /* receive buffer size */
#define SO_SNDLOWAT     0x1003          /* send low-water mark */
#define SO_RCVLOWAT     0x1004          /* receive low-water mark */
#define SO_SNDTIMEO     0x1005          /* send timeout */
#define SO_RCVTIMEO     0x1006          /* receive timeout */
#define SO_ERROR        0x1007          /* get error status and clear */
#define SO_TYPE         0x1008          /* get socket type */

/*
 * Structure used for manipulating linger option.
 */
struct  linger {
        int     l_onoff;                /* option on/off */
        int     l_linger;               /* linger time */
};

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
#define SOL_SOCKET      0xffff          /* options for socket level */

/*
 * Address families.
 */
#define AF_UNSPEC       0               /* unspecified */
#define AF_UNIX         1               /* local to host (pipes, portals) */
#define AF_INET         2               /* internetwork: UDP, TCP, etc. */
#define AF_IMPLINK      3               /* arpanet imp addresses */
#define AF_PUP          4               /* pup protocols: e.g. BSP */
#define AF_CHAOS        5               /* mit CHAOS protocols */
#define AF_NS           6               /* XEROX NS protocols */
#define AF_ISO          7               /* ISO protocols */
#define AF_OSI          AF_ISO
#define AF_ECMA         8               /* european computer manufacturers */
#define AF_DATAKIT      9               /* datakit protocols */
#define AF_CCITT        10              /* CCITT protocols, X.25 etc */
#define AF_SNA          11              /* IBM SNA */
#define AF_DECnet       12              /* DECnet */
#define AF_DLI          13              /* DEC Direct data link interface */
#define AF_LAT          14              /* LAT */
#define AF_HYLINK       15              /* NSC Hyperchannel */
#define AF_APPLETALK    16              /* Apple Talk */
#define AF_ROUTE        17              /* Internal Routing Protocol */
#define AF_LINK         18              /* Link layer interface */
#define pseudo_AF_XTP   19              /* eXpress Transfer Protocol (no AF) */

#define AF_MAX          20
/*

 * Structure used by kernel to store most
 * addresses.
 */
struct sockaddr {
        u_char  sa_len;                 /* total length */
        u_char  sa_family;              /* address family */
        char    sa_data[14];            /* actually longer; address value */
};

/*
 * Structure used by kernel to pass protocol
 * information in raw sockets.
 */
struct sockproto {
        u_short sp_family;              /* address family */
        u_short sp_protocol;            /* protocol */
};

/*
 * Protocol families, same as address families for now.
 */
#define PF_UNSPEC       AF_UNSPEC
#define PF_UNIX         AF_UNIX
#define PF_INET         AF_INET
#define PF_IMPLINK      AF_IMPLINK
#define PF_PUP          AF_PUP
#define PF_CHAOS        AF_CHAOS
#define PF_NS           AF_NS
#define PF_ISO          AF_ISO
#define PF_OSI          AF_ISO
#define PF_ECMA         AF_ECMA
#define PF_DATAKIT      AF_DATAKIT
#define PF_CCITT        AF_CCITT
#define PF_SNA          AF_SNA
#define PF_DECnet       AF_DECnet
#define PF_DLI          AF_DLI
#define PF_LAT          AF_LAT
#define PF_HYLINK       AF_HYLINK
#define PF_APPLETALK    AF_APPLETALK
#define PF_ROUTE        AF_ROUTE
#define PF_LINK         AF_LINK
#define PF_XTP          pseudo_AF_XTP   /* really just proto family, no AF */

#define PF_MAX          AF_MAX

/*
 * Maximum queue length specifiable by listen.
 */
#define SOMAXCONN       5

/*
 * Message header for recvmsg and sendmsg calls.
 * Used value-result for recvmsg, value only for sendmsg.
 */
struct msghdr {
        caddr_t msg_name;               /* optional address */
        u_int   msg_namelen;            /* size of address */
        struct  iovec *msg_iov;         /* scatter/gather array */
        u_int   msg_iovlen;             /* # elements in msg_iov */
        caddr_t msg_control;            /* ancillary data, see below */
        u_int   msg_controllen;         /* ancillary data buffer len */
        int     msg_flags;              /* flags on received message */
};

#define MSG_OOB         0x1             /* process out-of-band data */
#define MSG_PEEK        0x2             /* peek at incoming message */
#define MSG_DONTROUTE   0x4             /* send without using routing tables */
#define MSG_EOR         0x8             /* data completes record */
#define MSG_TRUNC       0x10            /* data discarded before delivery */
#define MSG_CTRUNC      0x20            /* control data lost before delivery */
#define MSG_WAITALL     0x40            /* wait for full request or error */

/*
 * Header for ancillary data objects in msg_control buffer.
 * Used for additional information with/about a datagram
 * not expressible by flags.  The format is a sequence
 * of message elements headed by cmsghdr structures.
 */
struct cmsghdr {
        u_int   cmsg_len;               /* data byte count, including hdr */
        int     cmsg_level;             /* originating protocol */
        int     cmsg_type;              /* protocol-specific type */
/* followed by  u_char  cmsg_data[]; */
};

/* given pointer to struct adatahdr, return pointer to data */
#define CMSG_DATA(cmsg)         ((u_char *)((cmsg) + 1))

/* given pointer to struct adatahdr, return pointer to next adatahdr */
#define CMSG_NXTHDR(mhdr, cmsg) \
        (((caddr_t)(cmsg) + (cmsg)->cmsg_len + sizeof(struct cmsghdr) > \
            (mhdr)->msg_control + (mhdr)->msg_controllen) ? \
            (struct cmsghdr *)NULL : \
            (struct cmsghdr *)((caddr_t)(cmsg) + ALIGN((cmsg)->cmsg_len)))

#define CMSG_FIRSTHDR(mhdr)     ((struct cmsghdr *)(mhdr)->msg_control)

/* "Socket"-level control message types: */
#define SCM_RIGHTS      0x01            /* access rights (array of int) */

/*
 * 4.3 compat sockaddr, move to compat file later
 */
struct osockaddr {
        u_short sa_family;              /* address family */
        char    sa_data[14];            /* up to 14 bytes of direct address */
};

/*
 * 4.3-compat message header (move to compat file later).
 */
struct omsghdr {
        caddr_t msg_name;               /* optional address */
        int     msg_namelen;            /* size of address */
        struct  iovec *msg_iov;         /* scatter/gather array */
        int     msg_iovlen;             /* # elements in msg_iov */
        caddr_t msg_accrights;          /* access rights sent/received */
        int     msg_accrightslen;
};

#include <sys/cdefs.h>
__BEGIN_DECLS
int     accept      __P((int, struct sockaddr __far *, int __far *));
int     bind        __P((int, const struct sockaddr __far *, int));
int     connect     __P((int, const struct sockaddr __far *, int));
int     getpeername __P((int, struct sockaddr __far *, int __far *));
int     getsockname __P((int, struct sockaddr __far *, int __far *));
int     getsockopt  __P((int, int, int, void __far *, int __far *));
int     gethostname __P((char __far *, int));
int     listen      __P((int, int));
int     recv        __P((int, void __far *, int, int));
int     recvfrom    __P((int, void __far *, int, int, struct sockaddr __far *, int __far *));
int     recvmsg     __P((int, struct msghdr __far *, int));
int     send        __P((int, const void __far *, int, int));
int     sendto      __P((int, const void __far *, int, int, const struct sockaddr __far *, int));
int     sendmsg     __P((int, const struct msghdr __far *, int));
int     setsockopt  __P((int, int, int, const void __far *, int));
int     shutdown    __P((int, int));
int     socket      __P((int, int, int));
int     socketpair  __P((int, int, int, int __far *));
int     select      __P((int, fd_set __far *, fd_set __far *, fd_set __far *, struct timeval __far *));
int     asyncselect __P((int, u_short, void (__loadds __far __pascal *)(int, u_short, u_long), u_long, void __far *));
int     sock_init   __P((void));
int     soclose     __P((int));
u_long  timeout     __P((void (__loadds __far __pascal *)(u_long), u_long, u_long, void __far *));
int     untimeout   __P((u_long));
__END_DECLS
#endif /*  _SOCKETS_ */
