/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p;

import com.fx702p.emulator.Fx702pBasicLine;
import com.fx702p.emulator.Fx702pBasicSourceCode;
import com.fx702p.emulator.Fx702pCommentLine;
import com.fx702p.emulator.TokenHelper;
import com.fx702p.parser.Fx702pParserConstants;
import com.fx702p.parser.Fx702pParserTokenManager;
import com.fx702p.parser.SimpleCharStream;
import com.fx702p.parser.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Fx702pParenthesisTokenManager
extends Fx702pParserTokenManager {
    private int parenthesisCounter = 0;
    private Token realToken = null;

    public Fx702pParenthesisTokenManager(InputStream aStream) throws UnsupportedEncodingException {
        super(new RecordingCharStream(aStream));
    }

    public Token getNextToken() {
        if (this.realToken != null) {
            if (this.parenthesisCounter == 0) {
                Token token = this.realToken;
                this.realToken = null;
                return token;
            }
            --this.parenthesisCounter;
            return new CloseParenthesisToken();
        }
        Token token = super.getNextToken();
        System.out.println(token);
        switch (token.kind) {
            case 99: {
                ++this.parenthesisCounter;
                break;
            }
            case 100: {
                --this.parenthesisCounter;
                break;
            }
            case 0: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                if (this.parenthesisCounter <= 0) break;
                this.realToken = token;
                --this.parenthesisCounter;
                token = new CloseParenthesisToken();
                break;
            }
        }
        return token;
    }

    public Fx702pBasicSourceCode getBasicSourceCode() {
        return ((RecordingCharStream)this.input_stream).getBasicSourceCode();
    }

    private static class RecordingCharStream
    extends SimpleCharStream {
        private Vector<Character> currentLine = null;
        private int currentLineIndex = -1;
        private Fx702pBasicSourceCode basicSourceCode = new Fx702pBasicSourceCode();
        private boolean endOfFileAlreadyFound = false;

        public RecordingCharStream(InputStream aStream) throws UnsupportedEncodingException {
            super(aStream, null, 1, 1);
        }

        public Fx702pBasicSourceCode getBasicSourceCode() {
            return this.basicSourceCode;
        }

        public char readChar() throws IOException {
            IOException endOfFile = null;
            char c = ' ';
            try {
                c = super.readChar();
            }
            catch (IOException exception) {
                endOfFile = exception;
            }
            if (!(this.endOfFileAlreadyFound || this.line == this.currentLineIndex && endOfFile == null)) {
                if (this.currentLine != null) {
                    StringBuilder builder = new StringBuilder();
                    for (Character character : this.currentLine) {
                        builder.append(character);
                    }
                    String lineAsString = builder.toString();
                    Fx702pBasicLine basicLine = TokenHelper.isComment(lineAsString) ? new Fx702pCommentLine(lineAsString) : new Fx702pBasicLine(TokenHelper.convertLine(lineAsString));
                    if (endOfFile == null) {
                        this.basicSourceCode.addLine(this.line - 2, basicLine);
                    } else {
                        this.basicSourceCode.addLine(this.line - 1, basicLine);
                    }
                }
                this.currentLine = new Vector();
                this.currentLineIndex = this.line;
            }
            if (endOfFile != null) {
                this.endOfFileAlreadyFound = true;
                throw endOfFile;
            }
            if (c != '\n' && c != '\r') {
                int currentSize = this.currentLine.size();
                if (this.column - 1 >= currentSize) {
                    this.currentLine.setSize(this.column);
                    for (int i = currentSize; i < this.column - 1; ++i) {
                        this.currentLine.set(i, Character.valueOf(' '));
                    }
                }
                this.currentLine.set(this.column - 1, Character.valueOf(c));
            }
            return c;
        }
    }

    private static class CloseParenthesisToken
    extends Token {
        public CloseParenthesisToken() {
            this.kind = 101;
            this.image = Fx702pParserConstants.tokenImage[100];
        }
    }
}

