/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class FormLayout
implements LayoutManager {
    protected int[] columnLabelWidth;
    protected int[] columnHeight;
    protected int[] columnWidth;
    protected int[] rowHeight;
    protected int[] columnFieldWidth;
    protected int columnCount = 1;
    protected Dimension preferredSize = null;
    protected final int horizontalGap;
    protected final int verticalGap;
    protected int sharedVerticalExtraSpace = -1;
    protected int horizontalExtraSpace;
    protected int horizontalPadding;
    protected boolean horizontallyCentered = true;
    public static final int MINIMUM_COLUMN_COUNT = 1;
    public static final int DEFAULT_HORIZONTAL_GAP = 10;
    public static final int DEFAULT_VERTICAL_GAP = 5;
    public static final int NO_SHARED_VERTICAL_EXTRA_SPACE = -1;

    public FormLayout() {
        this(10, 5);
        this.columnCount = 1;
    }

    public FormLayout(int anHorizontalGap, int aVerticalGap) {
        this.horizontalGap = anHorizontalGap;
        this.verticalGap = aVerticalGap;
        this.columnCount = 1;
    }

    public FormLayout(int aColumnCount) {
        this();
        if (aColumnCount > 1) {
            this.columnCount = aColumnCount;
        }
    }

    public FormLayout(int aColumnCount, boolean anHorizontallyCenteredFlag) {
        this(aColumnCount);
        this.horizontallyCentered = anHorizontallyCenteredFlag;
    }

    public FormLayout(int aColumnCount, int anHorizontalGap, int aVerticalGap) {
        this(anHorizontalGap, aVerticalGap);
        if (aColumnCount > 1) {
            this.columnCount = aColumnCount;
        }
    }

    public FormLayout(int aColumnCount, int anHorizontalGap, int aVerticalGap, boolean anHorizontallyCenteredFlag) {
        this(aColumnCount, anHorizontalGap, aVerticalGap);
        this.horizontallyCentered = anHorizontallyCenteredFlag;
    }

    public void reset() {
        this.preferredSize = null;
    }

    public void setVerticalExtraSpace(int aVerticalExtraSpace) {
        this.sharedVerticalExtraSpace = aVerticalExtraSpace;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this.preferredSize == null) {
            this.checkComponentCount(parent);
            this.computeSizes(parent, this.columnCount);
        }
        return this.preferredSize;
    }

    protected void checkComponentCount(Container aParentContainer) {
        if (aParentContainer.getComponentCount() % 2 != 0) {
            StringBuffer stringBuffer = new StringBuffer("Layout component count " + aParentContainer.getComponentCount() + " cannot be odd number");
            int last = aParentContainer.getComponentCount();
            for (int i = 0; i < last; ++i) {
                stringBuffer.append("Component " + i + " value " + aParentContainer.getComponent(i) + "\n");
            }
            System.err.println(stringBuffer);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Component label;
        int verticalExtraSpace;
        this.checkComponentCount(parent);
        this.computeSizes(parent, this.columnCount);
        Insets insets = parent.getInsets();
        Dimension parentSize = parent.getSize();
        this.buildHorizontalExtraSpaceAndPadding(parentSize);
        if (this.sharedVerticalExtraSpace != -1) {
            verticalExtraSpace = this.sharedVerticalExtraSpace;
        } else if (parentSize.height > this.preferredSize.height) {
            int verticalSpaces = (parent.getComponentCount() + 1) / 2 + 1;
            verticalExtraSpace = (parentSize.height - this.preferredSize.height) / verticalSpaces;
        } else {
            verticalExtraSpace = 0;
        }
        int rowVerticalPosition = insets.top + verticalExtraSpace;
        int labelColumnHorizontalPosition = insets.left + this.horizontalExtraSpace;
        int currentRow = 0;
        int currentColumn = 0;
        int[] previousElementHeight = new int[this.columnCount];
        int i = 0;
        int last = parent.getComponentCount();
        while (i + 1 < last) {
            Component label2 = parent.getComponent(i);
            Component field = parent.getComponent(i + 1);
            currentRow = i / (2 * this.columnCount);
            currentColumn = i / 2 % this.columnCount;
            Dimension labelDimension = null;
            Dimension fieldDimension = null;
            labelDimension = label2.isVisible() ? label2.getPreferredSize() : new Dimension(0, 0);
            fieldDimension = this.getFieldDimension(field, currentRow, currentColumn);
            int previousColumnsWidth = 0;
            for (int j = 0; j < currentColumn; ++j) {
                previousColumnsWidth += this.columnWidth[j] + this.horizontalGap + this.horizontalPadding;
            }
            int height = 0;
            if (currentRow > 0) {
                height = previousElementHeight[currentColumn];
            }
            int n = currentColumn;
            previousElementHeight[n] = previousElementHeight[n] + this.rowHeight[currentRow];
            int labelPositionX = labelColumnHorizontalPosition + previousColumnsWidth;
            int labelPositionY = rowVerticalPosition + height + (this.rowHeight[currentRow] - labelDimension.height) / 2;
            int fieldPositionX = labelPositionX + this.columnLabelWidth[currentColumn] + this.horizontalGap;
            int fieldPositionY = rowVerticalPosition + height + (this.rowHeight[currentRow] - fieldDimension.height) / 2;
            label2.setBounds(labelPositionX, labelPositionY, labelDimension.width, labelDimension.height);
            field.setBounds(fieldPositionX, fieldPositionY, fieldDimension.width, fieldDimension.height);
            i += 2;
        }
        if (parent.getComponentCount() % 2 != 0 && (label = parent.getComponent(parent.getComponentCount() - 1)).isVisible()) {
            Dimension labelDimension = label.getPreferredSize();
            label.setBounds(labelColumnHorizontalPosition, rowVerticalPosition, labelDimension.width, labelDimension.height);
        }
    }

    protected void buildHorizontalExtraSpaceAndPadding(Dimension aParentSize) {
        this.horizontalExtraSpace = this.horizontallyCentered && aParentSize.width > this.preferredSize.width ? (aParentSize.width - this.preferredSize.width) / 2 : 0;
        this.horizontalPadding = 0;
    }

    protected Dimension getLabelDimension(Component aLabel, int aRow, int aColumn) {
        return this.getComponentDefaultDimension(aLabel, aRow, aColumn);
    }

    protected Dimension getFieldDimension(Component aField, int aRow, int aColumn) {
        return this.getComponentDefaultDimension(aField, aRow, aColumn);
    }

    protected Dimension getComponentDefaultDimension(Component aComponent, int aRow, int aColumn) {
        if (aComponent.isVisible()) {
            return aComponent.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    protected void computeSizes(Container aParentContainer, int aColumnCount) {
        this.columnHeight = new int[aColumnCount];
        this.columnWidth = new int[aColumnCount];
        this.columnLabelWidth = new int[aColumnCount];
        int nbElement = aParentContainer.getComponentCount() / 2;
        int nbRow = nbElement <= 0 ? 0 : (nbElement - 1) / aColumnCount + 1;
        this.rowHeight = new int[nbRow];
        this.columnFieldWidth = new int[aColumnCount];
        int labelAndFieldIteration = 0;
        int i = 0;
        int last = aParentContainer.getComponentCount();
        while (i + 1 < last) {
            Component label = aParentContainer.getComponent(i);
            Component field = aParentContainer.getComponent(i + 1);
            Dimension fieldDimension = field.getPreferredSize();
            int fieldWidth = fieldDimension.width;
            int fieldHeight = fieldDimension.height;
            Dimension labelDimension = label.getPreferredSize();
            int labelWidth = labelDimension.width;
            int labelHeight = labelDimension.height;
            int column = labelAndFieldIteration % aColumnCount;
            this.columnFieldWidth[column] = Math.max(this.columnFieldWidth[column], fieldWidth);
            this.columnLabelWidth[column] = Math.max(this.columnLabelWidth[column], labelWidth);
            this.columnWidth[column] = Math.max(this.columnWidth[column], this.columnFieldWidth[column] + this.columnLabelWidth[column] + this.horizontalGap);
            int n = column;
            this.columnHeight[n] = this.columnHeight[n] + (Math.max(labelHeight, fieldHeight) + this.verticalGap);
            int row = labelAndFieldIteration / aColumnCount;
            this.rowHeight[row] = Math.max(this.rowHeight[row], Math.max(labelHeight, fieldHeight));
            ++labelAndFieldIteration;
            i += 2;
        }
        Insets insets = aParentContainer.getInsets();
        int parentWidth = insets.left + insets.right;
        for (int width : this.columnWidth) {
            parentWidth += width + this.horizontalGap;
        }
        int parentHeight = 0;
        for (int i2 = 0; i2 < this.rowHeight.length; ++i2) {
            int n = i2;
            this.rowHeight[n] = this.rowHeight[n] + this.verticalGap;
            parentHeight += this.rowHeight[i2];
        }
        this.preferredSize = new Dimension(parentWidth, parentHeight += insets.top + insets.bottom);
    }
}

