/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import uk.me.jstott.jcoord.CoordinateSystem;
import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.NotDefinedOnUTMGridException;
import uk.me.jstott.jcoord.datum.WGS84Datum;

public class UTMRef
extends CoordinateSystem {
    private double easting;
    private double northing;
    private char latZone;
    private int lngZone;

    public UTMRef(double d, double d2, char c, int n) throws NotDefinedOnUTMGridException {
        this(n, c, d, d2);
    }

    public UTMRef(int n, char c, double d, double d2) throws NotDefinedOnUTMGridException {
        super(WGS84Datum.getInstance());
        if (n < 1 || n > 60) {
            throw new NotDefinedOnUTMGridException("Longitude zone (" + n + ") is not defined on the UTM grid.");
        }
        if (c < 'C' || c > 'X') {
            throw new NotDefinedOnUTMGridException("Latitude zone (" + c + ") is not defined on the UTM grid.");
        }
        if (d < 0.0 || d > 1000000.0) {
            throw new NotDefinedOnUTMGridException("Easting (" + d + ") is not defined on the UTM grid.");
        }
        if (d2 < 0.0 || d2 > 1.0E7) {
            throw new NotDefinedOnUTMGridException("Northing (" + d2 + ") is not defined on the UTM grid.");
        }
        this.easting = d;
        this.northing = d2;
        this.latZone = c;
        this.lngZone = n;
    }

    @Override
    public LatLng toLatLng() {
        double d = 0.9996;
        double d2 = this.getDatum().getReferenceEllipsoid().getSemiMajorAxis();
        double d3 = this.getDatum().getReferenceEllipsoid().getEccentricitySquared();
        double d4 = d3 / (1.0 - d3);
        double d5 = (1.0 - Math.sqrt(1.0 - d3)) / (1.0 + Math.sqrt(1.0 - d3));
        double d6 = this.easting - 500000.0;
        double d7 = this.northing;
        int n = this.lngZone;
        char c = this.latZone;
        double d8 = ((double)n - 1.0) * 6.0 - 180.0 + 3.0;
        if (c - 78 < 0) {
            d7 -= 1.0E7;
        }
        double d9 = d7 / d;
        double d10 = d9 / (d2 * (1.0 - d3 / 4.0 - 3.0 * d3 * d3 / 64.0 - 5.0 * Math.pow(d3, 3.0) / 256.0));
        double d11 = d10 + (3.0 * d5 / 2.0 - 27.0 * Math.pow(d5, 3.0) / 32.0) * Math.sin(2.0 * d10) + (21.0 * d5 * d5 / 16.0 - 55.0 * Math.pow(d5, 4.0) / 32.0) * Math.sin(4.0 * d10) + 151.0 * Math.pow(d5, 3.0) / 96.0 * Math.sin(6.0 * d10);
        double d12 = d2 / Math.sqrt(1.0 - d3 * Math.sin(d11) * Math.sin(d11));
        double d13 = Math.tan(d11) * Math.tan(d11);
        double d14 = d4 * Math.cos(d11) * Math.cos(d11);
        double d15 = d2 * (1.0 - d3) / Math.pow(1.0 - d3 * Math.sin(d11) * Math.sin(d11), 1.5);
        double d16 = d6 / (d12 * d);
        double d17 = (d11 - d12 * Math.tan(d11) / d15 * (d16 * d16 / 2.0 - (5.0 + 3.0 * d13 + 10.0 * d14 - 4.0 * d14 * d14 - 9.0 * d4) * Math.pow(d16, 4.0) / 24.0 + (61.0 + 90.0 * d13 + 298.0 * d14 + 45.0 * d13 * d13 - 252.0 * d4 - 3.0 * d14 * d14) * Math.pow(d16, 6.0) / 720.0)) * 57.29577951308232;
        double d18 = d8 + (d16 - (1.0 + 2.0 * d13 + d14) * Math.pow(d16, 3.0) / 6.0 + (5.0 - 2.0 * d14 + 28.0 * d13 - 3.0 * d14 * d14 + 8.0 * d4 + 24.0 * d13 * d13) * Math.pow(d16, 5.0) / 120.0) / Math.cos(d11) * 57.29577951308232;
        return new LatLng(d17, d18);
    }

    public static char getUTMLatitudeZoneLetter(double d) {
        if (84.0 >= d && d >= 72.0) {
            return 'X';
        }
        if (72.0 > d && d >= 64.0) {
            return 'W';
        }
        if (64.0 > d && d >= 56.0) {
            return 'V';
        }
        if (56.0 > d && d >= 48.0) {
            return 'U';
        }
        if (48.0 > d && d >= 40.0) {
            return 'T';
        }
        if (40.0 > d && d >= 32.0) {
            return 'S';
        }
        if (32.0 > d && d >= 24.0) {
            return 'R';
        }
        if (24.0 > d && d >= 16.0) {
            return 'Q';
        }
        if (16.0 > d && d >= 8.0) {
            return 'P';
        }
        if (8.0 > d && d >= 0.0) {
            return 'N';
        }
        if (0.0 > d && d >= -8.0) {
            return 'M';
        }
        if (-8.0 > d && d >= -16.0) {
            return 'L';
        }
        if (-16.0 > d && d >= -24.0) {
            return 'K';
        }
        if (-24.0 > d && d >= -32.0) {
            return 'J';
        }
        if (-32.0 > d && d >= -40.0) {
            return 'H';
        }
        if (-40.0 > d && d >= -48.0) {
            return 'G';
        }
        if (-48.0 > d && d >= -56.0) {
            return 'F';
        }
        if (-56.0 > d && d >= -64.0) {
            return 'E';
        }
        if (-64.0 > d && d >= -72.0) {
            return 'D';
        }
        if (-72.0 > d && d >= -80.0) {
            return 'C';
        }
        return 'Z';
    }

    public String toString() {
        return this.lngZone + Character.toString(this.latZone) + " " + this.easting + " " + this.northing;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public char getLatZone() {
        return this.latZone;
    }

    public int getLngZone() {
        return this.lngZone;
    }
}

