/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.args;

import java.util.StringTokenizer;
import java.util.Vector;
import jonelo.sugar.args.InvalidArgumentException;

public class Arguments {
    private static final String colon = ":";
    private static final String equal = "=";
    private Vector spacesArgs;
    private Vector args;
    private Vector values;

    public Arguments(String[] argv, String arguments) {
        this.spacesArgs = new Vector();
        StringTokenizer st = new StringTokenizer(arguments, "|");
        while (st.hasMoreTokens()) {
            this.spacesArgs.add(st.nextToken());
        }
        this.constructor(argv);
    }

    public Arguments(String[] argv) {
        this.constructor(argv);
    }

    private void constructor(String[] argv) {
        this.args = new Vector();
        this.values = new Vector();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            int sepIndex = arg.indexOf(colon);
            if (sepIndex == -1 && arg.indexOf(equal) > -1) {
                sepIndex = arg.indexOf(equal);
            }
            if (sepIndex != -1) {
                this.args.add(arg.substring(0, sepIndex));
                this.values.add(arg.substring(sepIndex + 1));
                continue;
            }
            if (this.spacesArgs.indexOf(arg) > -1) {
                String argValue = "";
                if (i < argv.length - 1) {
                    argValue = argv[i + 1];
                    ++i;
                }
                this.args.add(arg);
                this.values.add(argValue);
                continue;
            }
            this.args.add(arg);
            this.values.add("");
        }
    }

    public boolean getBooleanValueOf(String arg) throws InvalidArgumentException {
        if (!this.receivedArgument(arg)) {
            throw new InvalidArgumentException("Invalid Argument: " + arg);
        }
        return this.truthOf(this.getValueOf(arg));
    }

    public String getStringValueOf(String arg) throws InvalidArgumentException {
        if (!this.receivedArgument(arg)) {
            throw new InvalidArgumentException("Invalid Argument: " + arg);
        }
        return this.getValueOf(arg);
    }

    public Double getDoubleValueOf(String arg) throws InvalidArgumentException {
        if (!this.receivedArgument(arg)) {
            throw new InvalidArgumentException("Invalid Argument: " + arg);
        }
        return Double.valueOf(this.getValueOf(arg));
    }

    public boolean receivedArgument(String arg) {
        return this.args.indexOf(arg) > -1;
    }

    public Vector listArguments() {
        return this.args;
    }

    public String toString() {
        String result = "{ ";
        for (int i = 0; i < this.args.size(); ++i) {
            result = result + this.args.get(i) + equal + this.values.get(i) + " ";
        }
        result = result + "}";
        return result;
    }

    private String getValueOf(String arg) {
        return (String)this.values.get(this.args.indexOf(arg));
    }

    private boolean truthOf(String val) throws InvalidArgumentException {
        if (val.substring(0, 1).equals("1") || val.substring(0, 1).toLowerCase().equals("y") || val.substring(0, 1).toLowerCase().equals("t")) {
            return true;
        }
        if (val.substring(0, 1).equals("0") || val.substring(0, 1).toLowerCase().equals("n") || val.substring(0, 1).toLowerCase().equals("f")) {
            return false;
        }
        if (val.toLowerCase().equals("no") || val.toLowerCase().equals("false") || val.toLowerCase().equals("off") || val.toLowerCase().equals("disable")) {
            return false;
        }
        if (val.toLowerCase().equals("yes") || val.toLowerCase().equals("true") || val.toLowerCase().equals("on") || val.toLowerCase().equals("enable")) {
            return true;
        }
        throw new InvalidArgumentException("Invalid Boolean Value in Argument: " + val);
    }
}

