/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.bytes;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import jonelo.sugar.bytes.Finding;
import jonelo.sugar.bytes.Findings;

public class GeneralBytes {
    public static final int UNLIMITED = -1;

    public static Finding search(String filename, byte[] bytesToFind, int additional) throws FileNotFoundException, IOException {
        Findings findings = GeneralBytes.search(filename, bytesToFind, additional, 1);
        if (findings.size() == 0) {
            return null;
        }
        return findings.get(0);
    }

    public static Finding search(InputStream in, byte[] bytesToFind, int additional) throws FileNotFoundException, IOException {
        Findings findings = GeneralBytes.search(in, bytesToFind, additional, 1);
        if (findings.size() == 0) {
            return null;
        }
        return findings.get(0);
    }

    public static byte[] cat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static Findings search(InputStream in, byte[] bytesToFind, int additional, int limit) throws FileNotFoundException, IOException {
        int numRead;
        Findings findings = new Findings();
        byte[] infobytes = new byte[additional];
        byte[] buf = new byte[4096];
        int index = 0;
        long offset = 0L;
        long found = 0L;
        while ((numRead = in.read(buf)) > 0) {
            for (int i = 0; i < numRead; ++i) {
                index = buf[i] == bytesToFind[index] ? ++index : 0;
                if (index != bytesToFind.length) continue;
                long offsetFound = offset + (long)i + 1L - (long)bytesToFind.length;
                for (int a = 0; a < additional; ++a) {
                    infobytes[a] = buf[i + 1 + a];
                }
                index = 0;
                findings.add(new Finding(offsetFound, GeneralBytes.cat(bytesToFind, infobytes)));
                if (limit == -1 || ++found < (long)limit) continue;
                in.close();
                return findings;
            }
            offset += (long)numRead;
        }
        in.close();
        return findings;
    }

    public static Findings search(String filename, byte[] bytesToFind, int additional, int limit) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(filename);
        return GeneralBytes.search(in, bytesToFind, additional, limit);
    }

    public static String bytes2hex(byte[] bytes) {
        StringBuilder outBuffer = new StringBuilder();
        for (int x = 0; x < bytes.length; ++x) {
            int by = bytes[x];
            int i = by >= 0 ? by : 256 + by;
            outBuffer.append(GeneralBytes.charFromHexDigit(i / 16));
            outBuffer.append(GeneralBytes.charFromHexDigit(i % 16));
        }
        return outBuffer.toString().toUpperCase(Locale.US);
    }

    private static char charFromHexDigit(int digit) {
        if (digit >= 0 && digit <= 9) {
            return (char)(digit + 48);
        }
        return (char)(digit - 10 + 97);
    }

    public static String bytes2text(byte[] bytes) {
        StringBuilder outBuffer = new StringBuilder();
        for (int x = 0; x < bytes.length; ++x) {
            char v = (char)bytes[x];
            if (v >= ' ' && v < '\u007f') {
                outBuffer.append(v);
                continue;
            }
            outBuffer.append('.');
        }
        return outBuffer.toString();
    }

    public static byte[] hex2bytes(String sequence) throws NumberFormatException {
        byte[] bytearr = null;
        if (sequence.length() % 2 == 1) {
            throw new NumberFormatException("An even number of nibbles was expected.");
        }
        bytearr = new byte[sequence.length() / 2];
        int x = 0;
        int i = 0;
        while (i < sequence.length()) {
            String str = sequence.substring(i, i += 2);
            bytearr[x++] = (byte)Integer.parseInt(str, 16);
        }
        return bytearr;
    }
}

