/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.basic.BasicComboPopup;

public class GeneralGUI {
    private static Dimension dimension = null;
    public static final String LAF_METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String LAF_MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String LAF_WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String LAF_MAC = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    public static final String LAF_AQUA = "apple.laf.AquaLookAndFeel";
    public static final String LAF_GTK = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final int[] noTextChangeKeyEvents = new int[]{16, 10, 155, 40, 38, 37, 39, 36, 35, 33, 34, 144, 20, 27, 18, 65406, 17, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 61440, 61441, 61442, 61443, 61444, 61445, 61446, 61447, 61448, 61449, 61450, 61451};

    public static void centerComponent(Component component) {
        if (dimension == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
        }
        component.setLocation(new Point((GeneralGUI.dimension.width - component.getSize().width) / 2, (GeneralGUI.dimension.height - component.getSize().height) / 2));
    }

    public static void setLocationRelativeTo(Component component, Component c) {
        Container root = null;
        if (c != null) {
            if (c instanceof Window) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (c != null && !c.isShowing() || root == null || !root.isShowing()) {
            Dimension paneSize = component.getSize();
            Dimension screenSize = component.getToolkit().getScreenSize();
            component.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
        } else {
            Dimension invokerSize = c.getSize();
            Point invokerScreenLocation = new Point(0, 0);
            for (Component tc = c; tc != null; tc = tc.getParent()) {
                Point tcl = tc.getLocation();
                invokerScreenLocation.x += tcl.x;
                invokerScreenLocation.y += tcl.y;
                if (tc == root) break;
            }
            Rectangle windowBounds = component.getBounds();
            int dx = invokerScreenLocation.x + (invokerSize.width - windowBounds.width >> 1);
            int dy = invokerScreenLocation.y + (invokerSize.height - windowBounds.height >> 1);
            Dimension ss = component.getToolkit().getScreenSize();
            if (dy + windowBounds.height > ss.height) {
                dy = ss.height - windowBounds.height;
                int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - windowBounds.width;
            }
            if (dx + windowBounds.width > ss.width) {
                dx = ss.width - windowBounds.width;
            }
            if (dx < 0) {
                dx = 0;
            }
            if (dy < 0) {
                dy = 0;
            }
            component.setLocation(dx, dy);
        }
    }

    public static void maximizeComponent(Component component) {
        if (dimension == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
        }
        component.setSize(dimension);
        component.setLocation(0, 0);
    }

    public static boolean isLookAndFeelAvailable(String s) {
        try {
            Class<?> myclass = Class.forName(s);
            LookAndFeel lookandfeel = (LookAndFeel)myclass.newInstance();
            return lookandfeel.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void applyOrientation(Component c, ComponentOrientation o) {
        block3: {
            block2: {
                c.setComponentOrientation(o);
                if (!(c instanceof JMenu)) break block2;
                JMenu menu = (JMenu)c;
                int ncomponents = menu.getMenuComponentCount();
                for (int i = 0; i < ncomponents; ++i) {
                    GeneralGUI.applyOrientation(menu.getMenuComponent(i), o);
                }
                break block3;
            }
            if (!(c instanceof Container)) break block3;
            Container container = (Container)c;
            int ncomponents = container.getComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                GeneralGUI.applyOrientation(container.getComponent(i), o);
            }
        }
    }

    public static void resizeComboBoxPopup(JComboBox box) {
        if (box.getSize().getWidth() == 0.0) {
            return;
        }
        FontMetrics fm = box.getFontMetrics(box.getFont());
        BasicComboPopup popup = (BasicComboPopup)box.getUI().getAccessibleChild(box, 0);
        if (popup == null) {
            return;
        }
        int size = (int)box.getPreferredSize().getWidth();
        for (int i = 0; i < box.getItemCount(); ++i) {
            String str = box.getItemAt(i).toString();
            if (size >= fm.stringWidth(str)) continue;
            size = fm.stringWidth(str);
        }
        size += 40;
        int h = ((JComponent)((Object)box.getRenderer())).getPreferredSize().height;
        int min = Math.min(box.getItemCount(), box.getMaximumRowCount());
        Component comp = popup.getComponent(0);
        JScrollPane scrollpane = null;
        if (comp instanceof JScrollPane) {
            scrollpane = (JScrollPane)comp;
            if (box.getItemCount() > box.getMaximumRowCount()) {
                size = (int)((double)size + scrollpane.getVerticalScrollBar().getPreferredSize().getWidth());
            }
        }
        int max = Math.max(size, (int)box.getSize().getWidth());
        max = Math.min(max, 640);
        popup.setPreferredSize(new Dimension(max, min * h + 2));
        popup.setLayout(new BorderLayout());
        popup.add(comp, "Center");
    }

    public static ComboBoxModel getComboBoxModel(Vector data) {
        JComboBox cb = new JComboBox(data);
        return cb.getModel();
    }

    public static ComboBoxModel getComboBoxModel(JLabel[] data) {
        JComboBox<JLabel> cb = new JComboBox<JLabel>(data);
        return cb.getModel();
    }

    public static ComboBoxModel getComboBoxModel(String[] data) {
        JComboBox<String> cb = new JComboBox<String>(data);
        return cb.getModel();
    }

    public static ListModel getListModel(Vector data) {
        JList jl = new JList(data);
        return jl.getModel();
    }
}

