/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeneralNet {
    public static String downloadAsText(String myurl) throws MalformedURLException, IOException {
        return GeneralNet.downloadAsText(myurl, 16);
    }

    public static String downloadAsText(String myurl, int buffersize) throws MalformedURLException, IOException {
        String str;
        StringBuilder sb = new StringBuilder(buffersize);
        URL url = new URL(myurl);
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((str = in.readLine()) != null) {
            sb.append(str);
            sb.append("\n");
        }
        in.close();
        return sb.toString();
    }

    public static String whatIsTheLatestTzdata() throws Exception {
        String LINK = "ftp://ftp.iana.org/tz/";
        String tzdata = null;
        try {
            String content = GeneralNet.downloadAsText("ftp://ftp.iana.org/tz/", 800);
            String[] lines = content.split("\n");
            content = null;
            Pattern pattern = Pattern.compile("(tzdata\\d{4}.)");
            boolean found = false;
            for (int i = 0; i < lines.length && !found; ++i) {
                int index = lines[i].indexOf("tzdata-latest.tar.gz");
                if (index <= 0) continue;
                Matcher matcher = pattern.matcher(lines[i]);
                if (!matcher.find()) {
                    throw new Exception("tzdata information cannot be determined from ftp://ftp.iana.org/tz/");
                }
                tzdata = matcher.group(1);
                found = true;
            }
        }
        catch (IOException ioe) {
            throw new Exception("Cannot connect to ftp://ftp.iana.org/tz/");
        }
        if (tzdata == null) {
            throw new Exception("ftp://ftp.iana.org/tz/ doesn't provide tzdata information.");
        }
        return tzdata;
    }
}

