/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jonelo.sugar.bytes.Finding;
import jonelo.sugar.bytes.GeneralBytes;

public final class GeneralProgram {
    public static void requiresMinimumJavaVersion(String version) {
        try {
            String ver = System.getProperty("java.version");
            if (GeneralProgram.isJ2SEcompatible() && ver.compareTo(version) < 0) {
                System.out.println("ERROR: a later Java Runtime Environment is required.\nVendor of Java:                " + System.getProperty("java.vendor") + "\nVersion of Java:               " + ver + "\nRequired minimum Java version: " + version);
                System.exit(1);
            }
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    public static boolean isSupportFor(String version) {
        return GeneralProgram.isJ2SEcompatible() ? System.getProperty("java.version").compareTo(version) >= 0 : false;
    }

    public static boolean isJ2SEcompatible() {
        String vendor = System.getProperty("java.vendor");
        return !vendor.startsWith("Free Software Foundation") && !vendor.startsWith("Kaffe.org") && !vendor.startsWith("CACAO Team");
    }

    public static boolean isJavaSEcompatible() {
        return GeneralProgram.isJ2SEcompatible();
    }

    public static String getTimeZoneDataVersion() throws IOException, Exception {
        String timeZoneDirName = GeneralProgram.getTimeZoneDirName();
        if (timeZoneDirName != null) {
            Finding finding = GeneralBytes.search(timeZoneDirName + "ZoneInfoMappings", "tzdata".getBytes(), 5);
            if (finding == null) {
                finding = GeneralBytes.search(timeZoneDirName + "ZoneInfoMappings", "20".getBytes(), 3);
            }
            if (finding == null) {
                throw new Exception("tzdata version cannot be determined.");
            }
            String temp = new String(finding.getSequence());
            if (!temp.startsWith("tzdata")) {
                temp = "tzdata" + temp;
            }
            return temp;
        }
        String filenameAbsolute = GeneralProgram.findTimeZoneJarFile("tzdb.dat");
        if (filenameAbsolute != null) {
            Finding finding = GeneralProgram.readTimeZoneDatFile(filenameAbsolute);
            return "tzdata" + new String(finding.getSequence());
        }
        filenameAbsolute = GeneralProgram.findTimeZoneJarFile("tzdb.jar");
        if (filenameAbsolute != null) {
            Finding finding = GeneralProgram.readTimeZoneJarFile(filenameAbsolute);
            return "tzdata" + new String(finding.getSequence());
        }
        throw new Exception("Timezone database file hasn't been found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Finding readTimeZoneDatFile(String filename) throws Exception {
        Finding finding = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(filename);
            finding = GeneralBytes.search(is, "20".getBytes(), 3);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
        if (finding == null) {
            throw new Exception("tzdata version cannot be determined.");
        }
        return finding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Finding readTimeZoneJarFile(String filename) throws Exception {
        Finding finding = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(filename);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            String TZDB = "TZDB.dat";
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryName = zipEntry.getName();
                if (!entryName.equals("TZDB.dat")) continue;
                if (zipEntry.getSize() > 0L) {
                    InputStream is = zipFile.getInputStream(zipEntry);
                    if (is == null) {
                        throw new Exception("Resource TZDB.dat was not found.");
                    }
                    finding = GeneralBytes.search(is, "20".getBytes(), 3);
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
        if (finding == null) {
            throw new Exception("tzdata version cannot be determined.");
        }
        return finding;
    }

    private static String findTimeZoneJarFile(String filename) {
        String prefix = System.getProperty("java.home") + File.separator;
        String jre = "jre" + File.separator;
        String postfix = "lib" + File.separator + filename;
        String test1 = prefix + jre + postfix;
        File file1 = new File(test1);
        if (file1.isFile()) {
            return test1;
        }
        String test2 = prefix + postfix;
        File file2 = new File(test2);
        if (file2.isFile()) {
            return test2;
        }
        return null;
    }

    private static String getTimeZoneDirName() {
        String prefix = System.getProperty("java.home") + File.separator;
        String jre = "jre" + File.separator;
        String postfix = "lib" + File.separator + "zi" + File.separator;
        String test1 = prefix + jre + postfix;
        File file1 = new File(test1);
        if (file1.isDirectory()) {
            return test1;
        }
        String test2 = prefix + postfix;
        File file2 = new File(test2);
        if (file2.isDirectory()) {
            return test2;
        }
        return null;
    }
}

