/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import net.beeger.squareness.SquarenessLookAndFeel;
import net.beeger.squareness.util.SquarenessBorderFactory;

public class SquarenessScrollBarUI
extends BasicScrollBarUI {
    private ScrollBarMouseMotionListener _scrollBarMouseMotionListener;
    private ScrollBarMouseListener _scrollBarMouseListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SquarenessScrollBarUI();
    }

    public void installUI(JComponent jComponent) {
        jComponent.putClientProperty("SquarenessRollover", Boolean.FALSE);
        jComponent.putClientProperty("SquarenessScrollBarThumbPressed", Boolean.FALSE);
        jComponent.putClientProperty("SquarenessScrollBarTrackPressed", Boolean.FALSE);
        this._scrollBarMouseMotionListener = new ScrollBarMouseMotionListener();
        this._scrollBarMouseListener = new ScrollBarMouseListener();
        jComponent.addMouseMotionListener(this._scrollBarMouseMotionListener);
        jComponent.addMouseListener(this._scrollBarMouseListener);
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removeMouseMotionListener(this._scrollBarMouseMotionListener);
        jComponent.removeMouseListener(this._scrollBarMouseListener);
        super.uninstallUI(jComponent);
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Color color = graphics.getColor();
        boolean bl = this.scrollbar.getClientProperty("SquarenessRollover").equals(Boolean.TRUE);
        boolean bl2 = this.scrollbar.getClientProperty("SquarenessScrollBarThumbPressed").equals(Boolean.TRUE);
        ColorUIResource colorUIResource = bl || bl2 ? SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor();
        graphics.setColor(colorUIResource);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        if (bl2) {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundShadowColor());
            graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, 2);
            graphics.fillRect(rectangle.x + 1, rectangle.y + 1, 2, rectangle.height - 2);
        }
        graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        this.paintGripper(graphics, rectangle, colorUIResource, bl2, bl);
        graphics.setColor(color);
    }

    private void paintGripper(Graphics graphics, Rectangle rectangle, Color color, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.scrollbar.getOrientation() == 0;
        if (bl3 && rectangle.getWidth() > 16.0 || !bl3 && rectangle.getHeight() > 16.0) {
            int n = 0;
            int n2 = 0;
            Color color2 = color.darker();
            Color color3 = color.brighter();
            n = rectangle.x + (rectangle.width >> 1) - 3;
            n2 = rectangle.y + (rectangle.height >> 1) - 3;
            graphics.translate(n, n2);
            if (bl3) {
                if (bl || bl2) {
                    graphics.translate(0, 1);
                    graphics.setColor(color2);
                    this.paintHorizontalGripperPart(graphics);
                    graphics.setColor(color3);
                    graphics.translate(1, 1);
                    this.paintHorizontalGripperPart(graphics);
                    graphics.translate(-1, -1);
                    graphics.translate(0, -1);
                } else {
                    graphics.setColor(color3);
                    this.paintHorizontalGripperPart(graphics);
                    graphics.setColor(color2);
                    graphics.translate(1, 1);
                    this.paintHorizontalGripperPart(graphics);
                    graphics.translate(-1, -1);
                }
            } else if (bl || bl2) {
                graphics.translate(1, 0);
                graphics.setColor(color2);
                this.paintVerticalGripperPart(graphics);
                graphics.setColor(color3);
                graphics.translate(1, 1);
                this.paintVerticalGripperPart(graphics);
                graphics.translate(-1, -1);
                graphics.translate(-1, 0);
            } else {
                graphics.setColor(color3);
                this.paintVerticalGripperPart(graphics);
                graphics.setColor(color2);
                graphics.translate(1, 1);
                this.paintVerticalGripperPart(graphics);
                graphics.translate(-1, -1);
            }
            graphics.translate(-n, -n2);
        }
    }

    protected void paintVerticalGripperPart(Graphics graphics) {
        this.paintVerticalGripperPartColumn(graphics);
        graphics.translate(4, 0);
        this.paintVerticalGripperPartColumn(graphics);
        graphics.translate(-4, 0);
    }

    protected void paintVerticalGripperPartColumn(Graphics graphics) {
        graphics.drawLine(0, 0, 1, 0);
        graphics.drawLine(0, 2, 1, 2);
        graphics.drawLine(0, 4, 1, 4);
        graphics.drawLine(0, 6, 1, 6);
    }

    protected void paintHorizontalGripperPart(Graphics graphics) {
        this.paintHorizontalGripperPartRow(graphics);
        graphics.translate(0, 4);
        this.paintHorizontalGripperPartRow(graphics);
        graphics.translate(0, -4);
    }

    protected void paintHorizontalGripperPartRow(Graphics graphics) {
        graphics.drawLine(0, 0, 0, 1);
        graphics.drawLine(2, 0, 2, 1);
        graphics.drawLine(4, 0, 4, 1);
        graphics.drawLine(6, 0, 6, 1);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Color color = graphics.getColor();
        if (Boolean.TRUE.equals(this.scrollbar.getClientProperty("SquarenessScrollBarTrackPressed"))) {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getPressedScrollBarTrackBackgroundColor());
        } else {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        if (this.scrollbar.getOrientation() == 1) {
            graphics.drawLine(rectangle.x, 0, rectangle.x, this.scrollbar.getHeight() - 1);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, this.scrollbar.getHeight() - 1);
        } else {
            graphics.drawLine(0, rectangle.y, this.scrollbar.getWidth() - 1, rectangle.y);
            graphics.drawLine(0, rectangle.height - 1, this.scrollbar.getWidth() - 1, rectangle.height - 1);
        }
        graphics.setColor(color);
    }

    protected JButton createIncreaseButton(int n) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        int n2 = uIDefaults.getInt("ScrollBar.width");
        SquarenessScrollBarButton squarenessScrollBarButton = new SquarenessScrollBarButton();
        Dimension dimension = new Dimension(n2, n2);
        squarenessScrollBarButton.setPreferredSize(dimension);
        squarenessScrollBarButton.setMinimumSize(dimension);
        if (this.scrollbar.getOrientation() == 0) {
            squarenessScrollBarButton.setIcon(uIDefaults.getIcon("scrollArrowRight"));
        } else {
            squarenessScrollBarButton.setIcon(uIDefaults.getIcon("scrollArrowDown"));
        }
        squarenessScrollBarButton.setHorizontalAlignment(0);
        squarenessScrollBarButton.setVerticalAlignment(0);
        return squarenessScrollBarButton;
    }

    protected JButton createDecreaseButton(int n) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        int n2 = uIDefaults.getInt("ScrollBar.width");
        SquarenessScrollBarButton squarenessScrollBarButton = new SquarenessScrollBarButton();
        Dimension dimension = new Dimension(n2, n2);
        squarenessScrollBarButton.setPreferredSize(dimension);
        squarenessScrollBarButton.setMinimumSize(dimension);
        if (this.scrollbar.getOrientation() == 0) {
            squarenessScrollBarButton.setIcon(uIDefaults.getIcon("scrollArrowLeft"));
        } else {
            squarenessScrollBarButton.setIcon(uIDefaults.getIcon("scrollArrowUp"));
        }
        squarenessScrollBarButton.setHorizontalAlignment(0);
        squarenessScrollBarButton.setVerticalAlignment(0);
        return squarenessScrollBarButton;
    }

    private class ScrollBarMouseListener
    extends MouseAdapter {
        private ScrollBarMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle rectangle = SquarenessScrollBarUI.this.getThumbBounds();
            Rectangle rectangle2 = SquarenessScrollBarUI.this.getTrackBounds();
            if (rectangle.contains(mouseEvent.getPoint()) && SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessScrollBarThumbPressed").equals(Boolean.FALSE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessScrollBarThumbPressed", Boolean.TRUE);
                SquarenessScrollBarUI.this.scrollbar.repaint(rectangle);
            } else if (rectangle2.contains(mouseEvent.getPoint()) && SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessScrollBarTrackPressed").equals(Boolean.FALSE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessScrollBarTrackPressed", Boolean.TRUE);
                SquarenessScrollBarUI.this.scrollbar.repaint(rectangle2);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Rectangle rectangle = SquarenessScrollBarUI.this.getThumbBounds();
            Rectangle rectangle2 = SquarenessScrollBarUI.this.getTrackBounds();
            if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessScrollBarThumbPressed").equals(Boolean.TRUE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessScrollBarThumbPressed", Boolean.FALSE);
                SquarenessScrollBarUI.this.scrollbar.repaint(rectangle);
            } else if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessScrollBarTrackPressed").equals(Boolean.TRUE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessScrollBarTrackPressed", Boolean.FALSE);
                SquarenessScrollBarUI.this.scrollbar.repaint(rectangle2);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessRollover").equals(Boolean.TRUE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessRollover", Boolean.FALSE);
                SquarenessScrollBarUI.this.scrollbar.repaint(SquarenessScrollBarUI.this.getThumbBounds());
            }
        }
    }

    private class ScrollBarMouseMotionListener
    extends MouseMotionAdapter {
        private ScrollBarMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Rectangle rectangle = SquarenessScrollBarUI.this.getThumbBounds();
            if (rectangle.contains(mouseEvent.getPoint())) {
                if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessRollover").equals(Boolean.FALSE)) {
                    SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessRollover", Boolean.TRUE);
                    SquarenessScrollBarUI.this.scrollbar.repaint(rectangle);
                }
            } else if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessRollover").equals(Boolean.TRUE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessRollover", Boolean.FALSE);
                SquarenessScrollBarUI.this.scrollbar.repaint(rectangle);
            }
        }
    }

    private static class SquarenessScrollBarButton
    extends JButton {
        private Border _border = SquarenessBorderFactory.getNonSpacingControlBorderWithMargin();

        private SquarenessScrollBarButton() {
        }

        public Border getBorder() {
            return this._border;
        }
    }
}

