/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import net.beeger.squareness.util.SquarenessButtonPainter;
import net.beeger.squareness.util.SquarenessListenerFactory;

public class SquarenessToggleButtonUI
extends BasicToggleButtonUI {
    private static SquarenessToggleButtonUI _buttonUI = new SquarenessToggleButtonUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return _buttonUI;
    }

    public void installUI(JComponent jComponent) {
        jComponent.putClientProperty("SquarenessRollover", Boolean.FALSE);
        jComponent.addMouseListener(SquarenessListenerFactory.getButtonRolloverMouseListener());
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removeMouseListener(SquarenessListenerFactory.getButtonRolloverMouseListener());
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Color color = graphics.getColor();
        SquarenessButtonPainter.paintButton(graphics, (AbstractButton)jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = abstractButton.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        graphics.setColor(abstractButton.getBackground());
        if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, abstractButton, rectangle2);
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else {
                this.paintText(graphics, abstractButton, rectangle3, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle3, rectangle2);
        }
        graphics.setColor(color);
    }
}

