/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AnalogClockBean
extends JComponent
implements Serializable {
    private static final double TWO_PI = Math.PI * 2;
    int updateInterval = 10;
    private Calendar now = Calendar.getInstance();
    private int diameter;
    private int centerX;
    private int centerY;
    private BufferedImage clockImage;
    private Timer timer;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private long millis;
    private Color backgroundColor;

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void setMillis(long l) {
        long l2 = this.millis;
        this.millis = l;
        this.now.setTimeInMillis(l);
        this.repaint();
        this.changes.firePropertyChange("millis", l2, l);
    }

    public void setIntervalInMillis(int n) {
        this._setIntervalInMillis(n);
    }

    public void setHours(int n) {
        this.now.set(14, 0);
        this.now.set(11, n);
    }

    public int getHours() {
        return this.now.get(11);
    }

    public void setMinutes(int n) {
        this.now.set(14, 0);
        this.now.set(12, n);
    }

    public int getMinutes() {
        return this.now.get(12);
    }

    public void setSeconds(int n) {
        this.now.set(14, 0);
        this.now.set(13, n);
    }

    public int getSeconds() {
        return this.now.get(13);
    }

    public AnalogClockBean() {
        this.setPreferredSize(new Dimension(250, 250));
        this._setIntervalInMillis(10);
    }

    private void _setIntervalInMillis(int n) {
        this.updateInterval = n;
        boolean bl = false;
        if (this.timer != null && this.timer.isRunning()) {
            bl = true;
            this.stop();
        }
        this.timer = new Timer(this.updateInterval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalogClockBean.this.setMillis(System.currentTimeMillis());
            }
        });
        if (bl) {
            this.start();
        }
    }

    public void start() {
        if (this.updateInterval > 10) {
            long l = 1000L - System.currentTimeMillis() % 1000L;
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        this.setMillis(System.currentTimeMillis());
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.diameter = n < n2 ? n : n2;
        --this.diameter;
        this.centerX = this.diameter / 2;
        this.centerY = this.diameter / 2;
        if (this.clockImage == null || this.clockImage.getWidth() != n || this.clockImage.getHeight() != n2) {
            this.clockImage = (BufferedImage)this.createImage(n, n2);
            Graphics2D graphics2D2 = this.clockImage.createGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawClockFace(graphics2D2);
        }
        graphics2D.drawImage(this.clockImage, null, 0, 0);
        this.drawClockHands(graphics2D);
    }

    private void drawClockHands(Graphics2D graphics2D) {
        int n = this.now.get(10);
        int n2 = this.now.get(12);
        int n3 = this.now.get(13);
        int n4 = this.now.get(14);
        int n5 = this.diameter / 8;
        int n6 = this.diameter / 2;
        double d = ((double)n3 + (double)n4 / 1000.0) / 60.0;
        graphics2D.setColor(Color.RED);
        this.drawRadius(graphics2D, d, 0, n6);
        graphics2D.setColor(Color.BLACK);
        n6 = this.diameter / 2 - 10;
        double d2 = ((double)n2 + d) / 60.0;
        this.drawRadius(graphics2D, d2, 0, n6);
        n6 = this.diameter / 4;
        this.drawRadius(graphics2D, ((double)n + d2) / 12.0, 0, n6);
    }

    private void drawClockFace(Graphics2D graphics2D) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillOval(0, 0, this.diameter, this.diameter);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawOval(0, 0, this.diameter, this.diameter);
        int n = this.diameter / 2;
        graphics2D.drawOval((this.diameter - 8) / 2, (this.diameter - 8) / 2, 8, 8);
        for (int i = 0; i < 60; ++i) {
            int n2 = i % 5 == 0 ? n - 20 : n - 5;
            this.drawRadius(graphics2D, (double)i / 60.0, n2, n);
        }
    }

    private void drawRadius(Graphics2D graphics2D, double d, int n, int n2) {
        double d2 = (0.5 - d) * (Math.PI * 2);
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        int n3 = this.centerX + (int)((double)n * d3);
        int n4 = this.centerY + (int)((double)n * d4);
        int n5 = this.centerX + (int)((double)n2 * d3);
        int n6 = this.centerY + (int)((double)n2 * d4);
        graphics2D.drawLine(n3, n4, n5, n6);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setMinimumSize(new Dimension(100, 100));
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle("Analog Clock");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        AnalogClockBean analogClockBean = new AnalogClockBean();
        jPanel.add((Component)analogClockBean, "Center");
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        analogClockBean.start();
        jFrame.setVisible(true);
    }
}

