/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.util.ArrayList;
import jonelo.sugar.math.GeneralMath;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryAngle
extends CategoryObject {
    public static final String PI = "3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632788";
    private static final int DEGREES = 0;
    private static final int minDEGREES = 1;
    private static final int secDEGREES = 2;
    private static final int RADIANS = 3;
    private static final int mRADIANS = 33;
    private static final int microRADIANS = 36;
    private static final int nanoRADIANS = 39;
    private static final int GON = 4;
    private static final int cGON = 5;
    private static final int mGON = 6;
    private static final int PERCENT = 7;
    private static final int PROMILLE = 70;
    private static final int MIL_NATO = 8;
    private static final int MIL_6000 = 6000;
    private static final int MIL_6300 = 6300;
    private static final int TURN = 9;
    private static final int MILLITURNS = 10;
    private static final int CENTITURNS = 11;
    private static final int NAUTICAL_POINT = 12;
    private static final int ZEITMASS = 13;
    private static final int ZEITMASS_MINUTES = 14;
    private static final int ZEITMASS_SECONDS = 15;
    private static final int RIGHT_ANGLE = 16;
    private static final BigDecimal _9 = BigDecimal.valueOf(9L);
    private static final BigDecimal _10 = BigDecimal.valueOf(10L);
    private static final BigDecimal _60 = BigDecimal.valueOf(60L);
    private static final BigDecimal _180 = BigDecimal.valueOf(180L);
    private static final BigDecimal _PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632788");
    private static String INVALID;
    private final ArrayList<Unit> units;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;

    public CategoryAngle(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.units = new ArrayList();
        this.units.add(new Unit(3, this.localize("Angle.radians", "Radians (rad)"), "siu"));
        this.units.add(new Unit(33, this.localize("Angle.milliRadians", "Milliradians (mrad)"), "siu"));
        this.units.add(new Unit(36, "Microradians (\u00b5rad)", "siu"));
        this.units.add(new Unit(39, "Nanoradians (nrad)", "siu"));
        this.units.add(new Unit(0, this.localize("Angle.degrees", "Degrees (deg)"), "int"));
        this.units.add(new Unit(1, this.localize("Angle.degreesMinutes", "Minute of arc (')"), "int"));
        this.units.add(new Unit(2, this.localize("Angle.degreesSeconds", "Second of arc ('')"), "int"));
        this.units.add(new Unit(13, this.localize("Angle.zeitmassHours", "Zeitma\u00df, Stundenma\u00df (in h)"), "int"));
        this.units.add(new Unit(14, this.localize("Angle.zeitmassMinutes", "Zeitma\u00df, Stundenma\u00df (in min)"), "int"));
        this.units.add(new Unit(15, this.localize("Angle.zeitmassSeconds", "Zeitma\u00df, Stundenma\u00df (in s)"), "int"));
        this.units.add(new Unit(4, this.localize("Angle.gon", "Gon (gon)"), "int"));
        this.units.add(new Unit(5, this.localize("Angle.centiGon", "Centigon (cgon)"), "int"));
        this.units.add(new Unit(6, this.localize("Angle.milliGon", "Milligon (mgon)"), "int"));
        this.units.add(new Unit(9, this.localize("Angle.turn", "Turn"), "int"));
        this.units.add(new Unit(11, this.localize("Angle.centiTurns", "Centiturns"), "int"));
        this.units.add(new Unit(10, this.localize("Angle.milliTurns", "Milliturns"), "int"));
        this.units.add(new Unit(16, this.localize("Angle.rightAngle", "Right angle"), "int"));
        this.units.add(new Unit(7, this.localize("Angle.circleInPercent", "Circle in percent (%)"), "int"));
        this.units.add(new Unit(70, this.localize("Angle.circleInPromille", "Circle in promille (\u2030)"), "int"));
        this.units.add(new Unit(12, this.localize("Angle.nauticalPoint", "Nautical Point (\u00af)"), "int"));
        this.units.add(new Unit(8, this.localize("Angle.mil", "Angular mil"), "int"));
        this.units.add(new Unit(8, "Artilleriepromille A\u2030", "ch"));
        this.units.add(new Unit(6000, this.localize("Angle.mil", "Angular mil"), "su_historic", false));
        this.units.add(new Unit(6000, this.localize("Angle.mil", "Angular mil"), "fi", false));
        this.units.add(new Unit(6300, this.localize("Angle.mil", "Angular mil") + " (Streck)", "se", false));
        this.defaultSourceUnit = this.units.get(0);
        this.defaultTargetUnit = this.units.get(4);
        this.transferUnit = this.units.get(4);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 0;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    public boolean isSpecialDefaultValue() {
        return false;
    }

    @Override
    public int getPreferredPrecision() {
        return 12;
    }

    @Override
    public boolean isScientificSupported() {
        return true;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        BigDecimal x = BigDecimal.ZERO;
        try {
            x = new BigDecimal(this.input.replace(decsep, '.'));
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        if (sid != tid) {
            switch (sid) {
                case 0: {
                    break;
                }
                case 1: {
                    x = x.divide(_60, this.getPrecision() + 1000, 4);
                    break;
                }
                case 2: {
                    x = x.divide(_60.multiply(_60), this.getPrecision() + 1000, 4);
                    break;
                }
                case 3: {
                    x = _180.divide(_PI, this.getPrecision() + 1000, 4).multiply(x);
                    break;
                }
                case 33: {
                    x = _180.divide(_PI, this.getPrecision() + 1000, 4).multiply(x);
                    x = x.movePointLeft(3);
                    break;
                }
                case 36: {
                    x = _180.divide(_PI, this.getPrecision() + 1000, 4).multiply(x);
                    x = x.movePointLeft(6);
                    break;
                }
                case 39: {
                    x = _180.divide(_PI, this.getPrecision() + 1000, 4).multiply(x);
                    x = x.movePointLeft(9);
                    break;
                }
                case 4: {
                    x = x.multiply(new BigDecimal("0.9"));
                    break;
                }
                case 5: {
                    x = x.multiply(new BigDecimal("0.009"));
                    break;
                }
                case 6: {
                    x = x.multiply(new BigDecimal("0.0009"));
                    break;
                }
                case 7: {
                    x = x.multiply(new BigDecimal("3.6"));
                    break;
                }
                case 70: {
                    x = x.multiply(new BigDecimal("0.36"));
                    break;
                }
                case 9: {
                    x = x.multiply(new BigDecimal("360"));
                    break;
                }
                case 10: {
                    x = x.multiply(new BigDecimal("0.360"));
                    break;
                }
                case 11: {
                    x = x.multiply(new BigDecimal("3.60"));
                    break;
                }
                case 16: {
                    x = x.multiply(new BigDecimal("90"));
                    break;
                }
                case 8: {
                    x = x.multiply(new BigDecimal("0.05625"));
                    break;
                }
                case 12: {
                    x = x.multiply(BigDecimal.valueOf(11.25));
                    break;
                }
                case 6000: {
                    x = x.multiply(new BigDecimal("0.06"));
                    break;
                }
                case 6300: {
                    x = this.multiplyBy(x, 2L, 35L);
                    break;
                }
                case 13: {
                    x = x.multiply(BigDecimal.valueOf(15L));
                    break;
                }
                case 14: {
                    x = x.multiply(BigDecimal.valueOf(0.25));
                    break;
                }
                case 15: {
                    x = this.multiplyBy(x, 1L, 240L);
                }
            }
            switch (tid) {
                case 0: {
                    break;
                }
                case 1: {
                    x = x.multiply(_60);
                    break;
                }
                case 2: {
                    x = x.multiply(_60.multiply(_60));
                    break;
                }
                case 3: {
                    x = _PI.divide(_180, this.getPrecision() + 1000, 4).multiply(x);
                    break;
                }
                case 33: {
                    x = _PI.divide(_180, this.getPrecision() + 1000, 4).multiply(x);
                    x = x.movePointRight(3);
                    break;
                }
                case 36: {
                    x = _PI.divide(_180, this.getPrecision() + 1000, 4).multiply(x);
                    x = x.movePointRight(6);
                    break;
                }
                case 39: {
                    x = _PI.divide(_180, this.getPrecision() + 1000, 4).multiply(x);
                    x = x.movePointRight(9);
                    break;
                }
                case 4: {
                    x = x.multiply(_10.divide(_9, this.getPrecision() + 1000, 4));
                    break;
                }
                case 5: {
                    x = x.multiply(_10.multiply(_10).multiply(_10).divide(_9, this.getPrecision() + 1000, 4));
                    break;
                }
                case 6: {
                    x = x.multiply(_10.multiply(_10).multiply(_10).multiply(_10).divide(_9, this.getPrecision() + 1000, 4));
                    break;
                }
                case 7: {
                    x = x.multiply(_10.divide(BigDecimal.valueOf(36L), this.getPrecision() + 1000, 4));
                    break;
                }
                case 70: {
                    x = x.multiply(_10.divide(BigDecimal.valueOf(3.6), this.getPrecision() + 1000, 4));
                    break;
                }
                case 8: {
                    x = x.multiply(BigDecimal.ONE.divide(BigDecimal.valueOf(0.05625), this.getPrecision() + 1000, 4));
                    break;
                }
                case 6000: {
                    x = x.multiply(BigDecimal.ONE.divide(BigDecimal.valueOf(0.06), this.getPrecision() + 1000, 4));
                    break;
                }
                case 6300: {
                    x = x.multiply(BigDecimal.valueOf(17.5));
                    break;
                }
                case 12: {
                    x = x.multiply(BigDecimal.valueOf(32L).divide(BigDecimal.valueOf(360L), this.getPrecision() + 1000, 4));
                    break;
                }
                case 9: {
                    x = x.multiply(BigDecimal.ONE.divide(BigDecimal.valueOf(360L), this.getPrecision() + 1000, 4));
                    break;
                }
                case 10: {
                    x = x.multiply(BigDecimal.ONE.divide(BigDecimal.valueOf(0.36), this.getPrecision() + 1000, 4));
                    break;
                }
                case 11: {
                    x = x.multiply(BigDecimal.ONE.divide(BigDecimal.valueOf(3.6), this.getPrecision() + 1000, 4));
                    break;
                }
                case 16: {
                    x = x.multiply(BigDecimal.ONE.divide(BigDecimal.valueOf(90L), this.getPrecision() + 1000, 4));
                    break;
                }
                case 13: {
                    x = this.multiplyBy(x, 1L, 15L);
                    break;
                }
                case 14: {
                    x = x.multiply(BigDecimal.valueOf(4L));
                    break;
                }
                case 15: {
                    x = x.multiply(BigDecimal.valueOf(240L));
                }
            }
        }
        if (this.getScientific()) {
            return GeneralMath.decimal2Scientific(x.toPlainString(), this.getPrecision()).replace('.', decsep);
        }
        return x.setScale(this.getPrecision(), 4).toPlainString().replace('.', decsep);
    }

    private BigDecimal multiplyBy(BigDecimal input, long z, long n) {
        return input.multiply(BigDecimal.valueOf(z).divide(BigDecimal.valueOf(n), this.getPrecision() + 1000, 4));
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        Unit sourceUnit = this.units.get(sourceindex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
        }
        BigDecimal big = new BigDecimal(this.input.replace(decsep, '.'));
        big = big.add(plus);
        return big.toPlainString().replace('.', decsep);
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.input.replace('.', decsep);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, sourceUnit).replace(decsep, '.');
    }

    @Override
    public String getCard() {
        return "sciCard";
    }
}

