/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.categories.LocaleComparator;
import net.numericalchameleon.data.Unit;

public class CategoryDateFormats
extends CategoryObject {
    private static final int cUTC = 0;
    private static final int cUNIXTIME = 1;
    private static final int cNUMBER = 2;
    private static final int cJULIAN = 3;
    private static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String NUMBERFORMAT = "yyyyMMddHHmmss";
    private static String INVALID;
    private static String INVALIDTARGET;
    private final ArrayList<Unit> units;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;
    private final TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    private final HashMap<Integer, Locale> localesHash;
    private int style = 2;

    public CategoryDateFormats(CategoryInterface clusterInterface) {
        this.rb = clusterInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        INVALIDTARGET = this.localize("Moduls.targetInvalid", "Target is invalid");
        this.units = new ArrayList();
        this.units.add(new Unit(0, "UTC (ISO 8601)", "int"));
        this.units.add(new Unit(1, "Unix Time (POSIX Time)", "int"));
        this.units.add(new Unit(2, "UTC (yyyyMMddHHmmss)", "int"));
        this.units.add(new Unit(3, "Julian Day Number (JDN)", "int"));
        this.transferUnit = this.units.get(2);
        this.defaultSourceUnit = this.units.get(0);
        this.defaultTargetUnit = this.units.get(1);
        Locale[] locales = Locale.getAvailableLocales();
        LocaleComparator comparator = new LocaleComparator();
        Arrays.sort(locales, comparator);
        this.localesHash = new HashMap();
        int id = 1000;
        for (Locale locale : locales) {
            String locinfo = locale.getCountry();
            if (locinfo == null || locinfo.length() <= 0) continue;
            String langinfo = locale.getLanguage();
            String variant = locale.getVariant();
            String info = variant != null && variant.length() > 0 ? locale.getDisplayLanguage() + "/" + locale.getDisplayCountry() + "/" + locale.getDisplayVariant() + " [" + langinfo + "_" + locinfo + "_" + variant + "]" : locale.getDisplayLanguage() + "/" + locale.getDisplayCountry() + " [" + langinfo + "_" + locinfo + "]";
            this.units.add(new Unit(id, "UTC (" + info + ")", locinfo.toLowerCase(Locale.US)));
            this.localesHash.put(id, locale);
            ++id;
        }
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public void setNumberType(int numberType) {
        switch (numberType) {
            case 0: {
                this.style = 3;
                break;
            }
            case 1: {
                this.style = 2;
                break;
            }
            case 2: {
                this.style = 1;
                break;
            }
            case 3: {
                this.style = 0;
                break;
            }
            default: {
                this.style = 2;
            }
        }
    }

    @Override
    public int getTargetDefault() {
        return 1;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public boolean isOneway() {
        return false;
    }

    private GregorianCalendar asSourceUnit(Unit sourceUnit) throws Exception {
        int sid = sourceUnit.getId();
        GregorianCalendar gc = new GregorianCalendar(this.timeZoneUTC);
        gc.setLenient(false);
        switch (sid) {
            case 0: {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(ISO_8601);
                    sdf.setTimeZone(this.timeZoneUTC);
                    gc.setTime(sdf.parse(this.input));
                    break;
                }
                catch (ParseException e) {
                    throw new Exception(INVALID);
                }
            }
            case 1: {
                try {
                    gc.setTimeInMillis(Long.parseLong(this.input) * 1000L);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new Exception(INVALID);
                }
            }
            case 2: {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(NUMBERFORMAT);
                    sdf.setTimeZone(this.timeZoneUTC);
                    gc.setTime(sdf.parse(this.input));
                    break;
                }
                catch (ParseException e) {
                    throw new Exception(INVALID);
                }
            }
            case 3: {
                try {
                    int jdn = Integer.parseInt(this.input);
                    fi.joensuu.joyds1.calendar.GregorianCalendar cal = new fi.joensuu.joyds1.calendar.GregorianCalendar(jdn);
                    GregorianCalendar gctemp = cal.toJavaUtilGregorianCalendar();
                    gctemp.setTimeZone(this.timeZoneUTC);
                    gc.setTime(gctemp.getTime());
                    break;
                }
                catch (NumberFormatException e) {
                    throw new Exception(INVALID);
                }
            }
            default: {
                try {
                    this.setGC(gc, this.input, this.localesHash.get(sid));
                    break;
                }
                catch (Exception e) {
                    throw new Exception(INVALID);
                }
            }
        }
        return gc;
    }

    private String asTargetUnit(GregorianCalendar gc, Unit targetUnit) throws Exception {
        int tid = targetUnit.getId();
        switch (tid) {
            case 0: {
                SimpleDateFormat sdf = new SimpleDateFormat(ISO_8601);
                sdf.setTimeZone(this.timeZoneUTC);
                return sdf.format(gc.getTime());
            }
            case 1: {
                return Long.toString(gc.getTimeInMillis() / 1000L);
            }
            case 2: {
                SimpleDateFormat sdf = new SimpleDateFormat(NUMBERFORMAT);
                sdf.setTimeZone(this.timeZoneUTC);
                return sdf.format(gc.getTime());
            }
            case 3: {
                fi.joensuu.joyds1.calendar.GregorianCalendar cal = new fi.joensuu.joyds1.calendar.GregorianCalendar(gc);
                return Integer.toString(cal.getJulianDayNumber());
            }
        }
        try {
            return this.formatGC(gc, this.localesHash.get(tid));
        }
        catch (Exception e) {
            throw new Exception(INVALIDTARGET);
        }
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        GregorianCalendar gc = this.asSourceUnit(sourceUnit);
        return this.asTargetUnit(gc, targetUnit);
    }

    private void setGC(GregorianCalendar gc, String input, Locale locale) throws Exception {
        DateFormat df = DateFormat.getDateTimeInstance(this.style, this.style, locale);
        SimpleDateFormat sdf = (SimpleDateFormat)df;
        String BC = sdf.getDateFormatSymbols().getEras()[0];
        if (input.contains(BC)) {
            throw new IllegalArgumentException("Before Christ values are not supported for this source unit");
        }
        df.setTimeZone(this.timeZoneUTC);
        gc.setTime(df.parse(input));
    }

    private String formatGC(GregorianCalendar gc, Locale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(this.style, this.style, locale);
        df.setTimeZone(this.timeZoneUTC);
        String append = "";
        if (gc.get(0) == 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("G", locale);
            append = " " + sdf.format(gc.getTime());
        }
        return df.format(gc.getTime()) + append;
    }

    @Override
    public String getInitialValue() {
        SimpleDateFormat sdf = new SimpleDateFormat(ISO_8601);
        sdf.setTimeZone(this.timeZoneUTC);
        return sdf.format(new Date());
    }

    @Override
    public String addValue(BigDecimal plus, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = this.getInitialValue();
            this.input = this.getOutput(this.defaultSourceUnit, sourceUnit);
        }
        int count = Integer.parseInt(plus.toPlainString());
        GregorianCalendar gc = this.asSourceUnit(sourceUnit);
        gc.add(5, count);
        this.setInput(this.asTargetUnit(gc, sourceUnit));
        return this.input;
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.getOutput(this.transferUnit, sourceUnit);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getCard() {
        return "dateCard";
    }
}

