/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jonelo.sugar.math.GeneralMath;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryGeneric
extends CategoryObject {
    private static String INVALID;
    private final ArrayList<Unit> units;
    private final boolean logic;
    private final String filename;

    public CategoryGeneric(String name, boolean logic, CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.logic = logic;
        this.filename = name;
        this.units = this.readTextFromJar("/data/units/" + name + ".list");
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    public boolean isSpecialDefaultValue() {
        return false;
    }

    @Override
    public boolean isScientificSupported() {
        return true;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        BigDecimal x = null;
        try {
            x = new BigDecimal(this.input.replace(decsep, '.'));
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        if (x.compareTo(BigDecimal.ZERO) != 0) {
            if (sourceUnit.isInvert()) {
                x = BigDecimal.valueOf(1L).divide(x, this.getPrecision() + 1000, 4);
            }
            if (sid != tid) {
                if (this.logic) {
                    x = x.multiply(sourceUnit.getFactor());
                    x = x.divide(targetUnit.getFactor(), this.getPrecision() + 1000, 4);
                } else {
                    x = x.divide(sourceUnit.getFactor(), this.getPrecision() + 1000, 4);
                    x = x.multiply(targetUnit.getFactor());
                }
            }
            if (targetUnit.isInvert()) {
                x = BigDecimal.ONE.divide(x, this.getPrecision() + 1000, 4);
            }
        }
        if (this.getScientific()) {
            return GeneralMath.decimal2Scientific(x.toPlainString(), this.getPrecision()).replace('.', decsep);
        }
        return x.setScale(this.getPrecision(), 4).toPlainString().replace('.', decsep);
    }

    private ArrayList<Unit> readTextFromJar(String filename) {
        ArrayList<Unit> units = null;
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            units = new ArrayList<Unit>();
            int id = 0;
            while ((thisLine = br.readLine()) != null) {
                BigDecimal bigdecimal;
                int pos;
                if (thisLine.length() <= 0 || thisLine.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(thisLine, ":");
                String description = GeneralString.decodeEncodedUnicode(st.nextToken());
                String strzahl = st.nextToken();
                boolean invert = false;
                if (strzahl.startsWith("!")) {
                    strzahl = strzahl.substring(1);
                    invert = true;
                }
                if ((pos = strzahl.indexOf("/")) == -1) {
                    bigdecimal = new BigDecimal(strzahl);
                } else {
                    BigDecimal fraction1 = new BigDecimal(strzahl.substring(0, pos));
                    BigDecimal fraction2 = new BigDecimal(strzahl.substring(pos + 1, strzahl.length()));
                    bigdecimal = fraction1.divide(fraction2, 1000, 4);
                }
                String flag = null;
                if (st.hasMoreTokens()) {
                    flag = st.nextToken().toLowerCase();
                }
                Unit ncr = new Unit(id, description, bigdecimal, flag);
                ncr.setInvert(invert);
                if (st.hasMoreTokens()) {
                    String temp = st.nextToken();
                    if (temp.equals("false")) {
                        ncr.setActive(false);
                    }
                    if (st.hasMoreTokens()) {
                        temp = st.nextToken();
                        if (temp.equals("source")) {
                            this.setSourceDefault(id);
                        }
                        if (temp.equals("target")) {
                            this.setTargetDefault(id);
                        }
                        if (temp.equals("source,target") || temp.equals("target,source")) {
                            this.setSourceDefault(id);
                            this.setTargetDefault(id);
                        }
                    }
                }
                units.add(ncr);
                ++id;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return units;
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
        }
        BigDecimal big = null;
        try {
            big = new BigDecimal(this.input.replace(decsep, '.'));
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        big = big.add(plus);
        return big.toString().replace('.', decsep);
    }

    @Override
    public String getTransferValue(int s) throws Exception {
        return this.getOutput(s, s).replace(decsep, '.');
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        this.setInput(big.toString());
        return this.input.replace('.', decsep);
    }

    @Override
    public String getCard() {
        return "sciCard";
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

