/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Properties;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;
import net.numericalchameleon.util.romannumerals.RomanNumeral;

public class CategoryRomanNumerals
extends CategoryObject {
    private final int _DEC = 0;
    private final int _ROM = 1;
    private static String INVALID;
    private final ArrayList<Unit> units;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;

    public CategoryRomanNumerals(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Roman.decimalInvalid", "Value is invalid.");
        this.units = new ArrayList();
        this.units.add(new Unit(0, this.localize("Moduls.decimalName", "Decimal"), "int"));
        this.units.add(new Unit(1, this.localize("Roman.roman", "Roman"), "int"));
        this.transferUnit = this.units.get(0);
        this.defaultSourceUnit = this.units.get(0);
        this.defaultTargetUnit = this.units.get(1);
        Properties romanl10n = new Properties();
        romanl10n.put(RomanNumeral.Errors.ISEMPTY.name(), this.localize("Roman.isEmpty", ""));
        romanl10n.put(RomanNumeral.Errors.INVALIDCHAR.name(), this.localize("Roman.invalidChar", ""));
        romanl10n.put(RomanNumeral.Errors.CHARONLYONCE.name(), this.localize("Roman.charOnlyOnce", ""));
        romanl10n.put(RomanNumeral.Errors.CHAR3TIMES.name(), this.localize("Roman.char3times", ""));
        romanl10n.put(RomanNumeral.Errors.CHAR4TIMES.name(), this.localize("Roman.char4times", ""));
        romanl10n.put(RomanNumeral.Errors.OUTOFRANGE.name(), this.localize("Roman.decimalRange", ""));
        RomanNumeral.setL10NProperties(romanl10n);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 1;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        RomanNumeral roman;
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        switch (sid) {
            case 0: {
                try {
                    roman = new RomanNumeral(Integer.parseInt(this.input));
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case 1: {
                roman = new RomanNumeral(this.input);
                break;
            }
            default: {
                throw new IllegalArgumentException("inernal error");
            }
        }
        switch (tid) {
            case 0: {
                return Long.toString(roman.toLong());
            }
            case 1: {
                return roman.toRoman();
            }
        }
        throw new IllegalArgumentException("inernal error");
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        Unit sourceUnit = this.units.get(sourceindex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "1";
            this.input = this.getOutput(this.transferUnit, sourceUnit);
        }
        String temp = this.getOutput(sourceUnit, this.transferUnit);
        BigDecimal big = new BigDecimal(temp);
        big = big.add(plus);
        this.input = big.toPlainString();
        return this.getOutput(this.transferUnit, sourceUnit);
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.getOutput(this.transferUnit, sourceUnit);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getCard() {
        return "emptyCard";
    }
}

