/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.bookmarks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.DefaultListModel;
import net.numericalchameleon.data.Bookmark;

public class BookmarksModel
extends DefaultListModel
implements Cloneable {
    private String filename;

    public BookmarksModel(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(this.filename);
            osw = new OutputStreamWriter((OutputStream)fos, "UnicodeBig");
            bw = new BufferedWriter(osw);
            for (int i = 0; i < this.size(); ++i) {
                bw.write(((Bookmark)this.get(i)).getBookmarkAsString());
                bw.write("\n");
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (osw != null) {
                osw.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        this.clear();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String string;
            fis = new FileInputStream(this.filename);
            isr = new InputStreamReader((InputStream)fis, "UnicodeBig");
            br = new BufferedReader(isr);
            while ((string = br.readLine()) != null) {
                this.add(this.getSize(), new Bookmark(string));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    private BookmarksModel(BookmarksModel bookmarks) {
        this.copyFrom(bookmarks);
    }

    public void copyFrom(BookmarksModel bookmarks) {
        this.filename = bookmarks.getFilename();
        this.clear();
        for (int i = 0; i < bookmarks.size(); ++i) {
            this.addElement(new Bookmark((Bookmark)bookmarks.getElementAt(i)));
        }
    }

    public Object clone() {
        return new BookmarksModel(this);
    }

    public static BookmarksModel loadBookmarks() {
        BookmarksModel temp = new BookmarksModel(System.getProperty("user.home") + File.separator + ".NumericalChameleon/.nc.bookmarks");
        try {
            temp.read();
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        return temp;
    }
}

