/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.ramdomgenerator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jonelo.sugar.io.GeneralIO;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.beans.Dice;
import net.numericalchameleon.gui.common.interfaces.DialogInterface;
import net.numericalchameleon.util.misc.RandomGenerator;

public class RandomGeneratorDialog
extends JDialog {
    private ResourceBundle rb;
    private List<Dice> dices;
    private int rollCount = 0;
    private JButton cancelButton;
    private JButton clearButton;
    private JCheckBox coloredDices;
    private JButton copyButton;
    private JCheckBox csvCheckBox;
    private JSpinner diceSpinner;
    private JButton generatorButton;
    private JTextField generatorCountTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField lowerboundTextField;
    private Dice myDice;
    private JPanel myPanel;
    private JScrollPane myScrollPane;
    private JCheckBox noDuplicatesCheckBox;
    private JCheckBox noticeCheckBox;
    private JScrollPane randomGeneratorScrollPane;
    private JTabbedPane randomGeneratorTabbedPane;
    private JButton rollButton;
    private JLabel rollCountLabel;
    private JCheckBox sortCheckBox;
    private JTextArea textArea;
    private JTextField upperboundTextField;

    public RandomGeneratorDialog(DialogInterface dialogInterface) {
        super(dialogInterface.getFrame(), false);
        this.rb = dialogInterface.getResourceBundle();
        this.initComponents();
        this.dices = new ArrayList<Dice>();
        this.dices.add(this.myDice);
        this.diceSpinner.setValue(3);
        this.setLocationRelativeTo(dialogInterface.getFrame());
        this.setVisible(true);
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.clearButton = new JButton();
        this.copyButton = new JButton();
        this.randomGeneratorScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.randomGeneratorTabbedPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.myScrollPane = new JScrollPane();
        this.myPanel = new JPanel();
        this.myDice = new Dice();
        this.jLabel1 = new JLabel();
        this.diceSpinner = new JSpinner();
        this.coloredDices = new JCheckBox();
        this.rollButton = new JButton();
        this.rollCountLabel = new JLabel();
        this.noticeCheckBox = new JCheckBox();
        this.csvCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.lowerboundTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.upperboundTextField = new JTextField();
        this.noDuplicatesCheckBox = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.generatorCountTextField = new JTextField();
        this.sortCheckBox = new JCheckBox();
        this.generatorButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.rb.getString("GUI.RandomGenerator.DialogTitle"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RandomGeneratorDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.rb.getString("GUI.General.Close"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomGeneratorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-clear.png")));
        this.clearButton.setText(this.rb.getString("GUI.General.Clear"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomGeneratorDialog.this.clearButtonActionPerformed(evt);
            }
        });
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.copyButton.setText(this.rb.getString("GUI.General.Copy"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomGeneratorDialog.this.copyButtonActionPerformed(evt);
            }
        });
        this.textArea.setFont(new Font("Courier", 0, 13));
        this.randomGeneratorScrollPane.setViewportView(this.textArea);
        this.myScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                RandomGeneratorDialog.this.myScrollPaneComponentResized(evt);
            }
        });
        this.myPanel.setLayout(new GridLayout(1, 0));
        GroupLayout myDiceLayout = new GroupLayout((Container)this.myDice);
        this.myDice.setLayout((LayoutManager)myDiceLayout);
        myDiceLayout.setHorizontalGroup(myDiceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 441, Short.MAX_VALUE));
        myDiceLayout.setVerticalGroup(myDiceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 312, Short.MAX_VALUE));
        this.myPanel.add((Component)this.myDice);
        this.myScrollPane.setViewportView(this.myPanel);
        this.jLabel1.setText(this.rb.getString("GUI.RandomGenerator.DieDice"));
        this.diceSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        this.diceSpinner.setValue(new Integer(1));
        this.diceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RandomGeneratorDialog.this.diceSpinnerStateChanged(evt);
            }
        });
        this.coloredDices.setText(this.rb.getString("GUI.RandomGenerator.ColoredDices"));
        this.coloredDices.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.coloredDices.setMargin(new Insets(0, 0, 0, 0));
        this.coloredDices.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RandomGeneratorDialog.this.coloredDicesItemStateChanged(evt);
            }
        });
        this.rollButton.setText(this.rb.getString("GUI.RandomGenerator.RollTheDice"));
        this.rollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomGeneratorDialog.this.rollButtonActionPerformed(evt);
            }
        });
        this.rollCountLabel.setText("---");
        this.noticeCheckBox.setSelected(true);
        this.noticeCheckBox.setText(this.rb.getString("GUI.RandomGenerator.MakeANote"));
        this.noticeCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noticeCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.noticeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RandomGeneratorDialog.this.noticeCheckBoxItemStateChanged(evt);
            }
        });
        this.noticeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomGeneratorDialog.this.noticeCheckBoxActionPerformed(evt);
            }
        });
        this.csvCheckBox.setText(this.rb.getString("GUI.RandomGenerator.csv"));
        this.csvCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomGeneratorDialog.this.csvCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rollCountLabel).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.diceSpinner, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)).addComponent(this.coloredDices).addComponent(this.noticeCheckBox).addGroup(jPanel1Layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.csvCheckBox)).addComponent(this.rollButton)).addGap(7, 7, 7).addComponent(this.myScrollPane, -1, 443, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.myScrollPane).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.rollCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.diceSpinner, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coloredDices).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noticeCheckBox).addGap(1, 1, 1).addComponent(this.csvCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.rollButton).addGap(194, 194, 194)))));
        this.randomGeneratorTabbedPane.addTab(this.rb.getString("GUI.RandomGenerator.RollTheDice"), this.jPanel1);
        this.jLabel2.setText(this.rb.getString("GUI.RandomGenerator.ValueFrom"));
        this.lowerboundTextField.setText("1");
        this.jLabel3.setText(this.rb.getString("GUI.RandomGenerator.ValueTo"));
        this.upperboundTextField.setText("49");
        this.noDuplicatesCheckBox.setSelected(true);
        this.noDuplicatesCheckBox.setText(this.rb.getString("GUI.RandomGenerator.NoDuplicateNumbers"));
        this.noDuplicatesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noDuplicatesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel4.setText(this.rb.getString("GUI.RandomGenerator.Quantity"));
        this.generatorCountTextField.setText("6");
        this.sortCheckBox.setSelected(true);
        this.sortCheckBox.setText(this.rb.getString("GUI.RandomGenerator.Sort"));
        this.sortCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sortCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.generatorButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/auction-hammer.png")));
        this.generatorButton.setText(this.rb.getString("GUI.RandomGenerator.Generate"));
        this.generatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomGeneratorDialog.this.generatorButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.generatorButton).addComponent(this.lowerboundTextField, GroupLayout.Alignment.LEADING, -1, 475, Short.MAX_VALUE).addComponent(this.upperboundTextField, GroupLayout.Alignment.LEADING, -1, 475, Short.MAX_VALUE).addComponent(this.generatorCountTextField, GroupLayout.Alignment.LEADING, -1, 475, Short.MAX_VALUE).addComponent(this.sortCheckBox, GroupLayout.Alignment.LEADING).addComponent(this.noDuplicatesCheckBox, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.lowerboundTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.upperboundTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noDuplicatesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generatorCountTextField, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortCheckBox).addGap(14, 14, 14).addComponent(this.generatorButton).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addContainerGap(161, Short.MAX_VALUE)));
        this.randomGeneratorTabbedPane.addTab(this.rb.getString("GUI.RandomGenerator.RandomGenerator"), this.jPanel2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.randomGeneratorTabbedPane, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cancelButton)).addComponent(this.randomGeneratorScrollPane, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.randomGeneratorTabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.randomGeneratorScrollPane, -2, 136, -2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearButton).addComponent(this.copyButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        String s = this.textArea.getSelectedText();
        if (s == null) {
            this.textArea.selectAll();
            s = this.textArea.getText();
        }
        GeneralIO.setClipboard(s);
        this.textArea.requestFocus();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.rollCount = 0;
        this.rollCountLabel.setText(this.rollCountText());
        this.textArea.setText("");
    }

    private void generatorButtonActionPerformed(ActionEvent evt) {
        int[] randoms;
        int upperbound;
        int lowerbound;
        int count;
        try {
            count = Integer.valueOf(this.generatorCountTextField.getText());
            lowerbound = Integer.valueOf(this.lowerboundTextField.getText());
            upperbound = Integer.valueOf(this.upperboundTextField.getText());
        }
        catch (Exception e) {
            this.textArea.append("Error: invalid input\n");
            System.err.println(e);
            return;
        }
        if (count > 1000) {
            this.textArea.append("Error: Sorry, not more than 1000 random numbers are supported.\n");
            return;
        }
        if (count < 1) {
            this.generatorCountTextField.setText("1");
            count = 1;
        }
        if (upperbound - lowerbound + 1 < count && this.noDuplicatesCheckBox.isSelected()) {
            this.noDuplicatesCheckBox.setSelected(false);
        }
        try {
            randoms = RandomGenerator.generate(count, lowerbound, upperbound, !this.noDuplicatesCheckBox.isSelected(), this.sortCheckBox.isSelected());
        }
        catch (IllegalArgumentException iae) {
            this.textArea.append("Error: " + iae.getMessage() + "\n");
            return;
        }
        StringBuilder sb = new StringBuilder(64);
        if (count > 0) {
            for (int i = 0; i < randoms.length; ++i) {
                sb.append(randoms[i]);
                if (i >= count - 1) continue;
                sb.append(",");
            }
            sb.append("\n");
            this.textArea.append(sb.toString());
            this.textArea.setCaretPosition(this.textArea.getText().length() - 1);
        }
    }

    private void noticeCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void noticeCheckBoxItemStateChanged(ItemEvent evt) {
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
    }

    private String rollCountText() {
        return GeneralString.message(this.rb.getString("GUI.RandomGenerator.ThrowNumber"), this.rollCount);
    }

    private void rollButtonActionPerformed(ActionEvent evt) {
        ++this.rollCount;
        this.rollCountLabel.setText(this.rollCountText());
        StringBuilder sb = new StringBuilder(64);
        if (this.noticeCheckBox.isSelected() && !this.csvCheckBox.isSelected()) {
            sb.append(this.rollCountText() + ": ");
        }
        for (int i = 0; i < this.dices.size(); ++i) {
            Dice dice = this.dices.get(i);
            dice.roll();
            if (!this.noticeCheckBox.isSelected()) continue;
            sb.append(String.valueOf(dice.getValue()));
            if (i >= this.dices.size() - 1) continue;
            sb.append(",");
        }
        if (this.noticeCheckBox.isSelected()) {
            sb.append("\n");
            this.textArea.append(sb.toString());
            this.textArea.setCaretPosition(this.textArea.getText().length() - 1);
        }
    }

    private void coloredDicesItemStateChanged(ItemEvent evt) {
        block3: {
            int change;
            block2: {
                change = evt.getStateChange();
                if (change != 1) break block2;
                for (int i = 0; i < this.dices.size(); ++i) {
                    this.dices.get(i).setRandomColor();
                }
                break block3;
            }
            if (change != 2) break block3;
            for (int i = 0; i < this.dices.size(); ++i) {
                this.dices.get(i).setColor(Dice.DICE_DEFAULT_COLOR);
            }
        }
    }

    private void diceSpinnerStateChanged(ChangeEvent evt) {
        JSpinner spinner = (JSpinner)evt.getSource();
        int spinnerValue = (Integer)spinner.getValue();
        while (this.dices.size() < spinnerValue) {
            this.addDice();
        }
        while (this.dices.size() > spinnerValue) {
            this.removeDice();
        }
    }

    private void myScrollPaneComponentResized(ComponentEvent evt) {
        this.updateScrollPane();
    }

    private void csvCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void updateScrollPane() {
        int dicesHorizontally = (int)((double)this.myScrollPane.getWidth() / this.myDice.getPreferredSize().getWidth());
        dicesHorizontally = Math.min(dicesHorizontally, this.dices.size());
        dicesHorizontally = Math.max(1, dicesHorizontally);
        this.myPanel.setLayout(new GridLayout(0, dicesHorizontally));
        this.myScrollPane.validate();
        this.myScrollPane.repaint();
    }

    private void removeDice() {
        if (this.dices.size() > 1) {
            Dice dice = this.dices.get(this.dices.size() - 1);
            this.myPanel.remove((Component)dice);
            this.dices.remove(dice);
            this.updateScrollPane();
        }
    }

    private void addDice() {
        Dice dice = new Dice();
        if (this.coloredDices.isSelected()) {
            dice.setRandomColor();
        }
        this.dices.add(dice);
        this.myPanel.add((Component)dice);
        this.updateScrollPane();
    }
}

