/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.updatecenter;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.numericalchameleon.gui.common.interfaces.I18NInterface;
import net.numericalchameleon.update.UpdateStatus;

public class UpdateStatusRenderer
extends JLabel
implements TableCellRenderer {
    private static final Color OUTDATED_COLOR = new Color(250, 106, 0);
    private static final Color UPTODATE_COLOR = new Color(69, 243, 85);
    private static final Color OLDER_COLOR = Color.YELLOW;
    private final I18NInterface i18nInterface;

    public UpdateStatusRenderer(I18NInterface i18nInterface) {
        this.i18nInterface = i18nInterface;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        UpdateStatus status = (UpdateStatus)object;
        switch (status.getStatus()) {
            case 1: {
                this.setBackground(OUTDATED_COLOR);
                break;
            }
            case 0: {
                this.setBackground(UPTODATE_COLOR);
                break;
            }
            case 2: {
                this.setBackground(Color.YELLOW);
                break;
            }
            case 3: {
                this.setBackground(OLDER_COLOR);
            }
        }
        this.setText(status.toString(this.i18nInterface));
        return this;
    }
}

