/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import net.numericalchameleon.data.Unit;

public class UnitRecordCellRenderer
extends DefaultListCellRenderer {
    private final ResourceBundle iso3166;
    private static final Color LIGHTGRAYDARKER = new Color(0x868686);

    public UnitRecordCellRenderer(ResourceBundle iso3166) {
        this.iso3166 = iso3166;
    }

    public ResourceBundle getISO3166ResourceBundle() {
        return this.iso3166;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            Unit unit = (Unit)value;
            String iconCode = unit.getIcon();
            if (this.iso3166 != null) {
                String countryName = this.iso3166.getString(iconCode);
                if (countryName != null) {
                    label.setToolTipText(String.format("%s: %s", countryName, unit.getText()));
                } else {
                    label.setToolTipText(unit.getText());
                }
            }
            try {
                URL url = this.getClass().getResource("/data/icons/flags/" + iconCode + ".png");
                label.setIcon(new ImageIcon(url));
            }
            catch (Exception exception) {
                // empty catch block
            }
            label.setText(unit.getText());
            label.setForeground(unit.getActive() ? label.getForeground() : LIGHTGRAYDARKER);
        }
        return label;
    }
}

