/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.update.modules;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import net.numericalchameleon.info.ProgInfo;
import net.numericalchameleon.update.modules.AbstractModule;

public class ProgramVersionModule
extends AbstractModule {
    public static final String LATEST_KNOWN_VERSION_VALUE = ProgInfo.getInstance().getVersion();
    public static final String LATEST_KNOWN_VERSION_PROPERTY_NAME = "latest_known_nc_version";
    public static final String LATEST_KNOWN_VERSION_PROPERTY_NAME_EXTERNALLY = "latest_version";
    public static final String DOWNLOAD_URL_PROPERTY_NAME_EXTERNALLY = "download_url";
    private static final String PROPERTY_URL_VALUE = ProgInfo.getInstance().getFullHomepage() + "/download/update.properties";
    private static final String DOWNLOAD_URL_VALUE = ProgInfo.getInstance().getFullHomepage() + "/";
    private Properties props;

    public ProgramVersionModule() {
        this.name = ProgInfo.getInstance().getProgramName();
        this.vendor = ProgInfo.getInstance().getVendor();
        this.installedVersion = ProgInfo.getInstance().getVersion();
        this.latestKnownVersion = LATEST_KNOWN_VERSION_VALUE;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void gatherProperties(boolean force) throws MalformedURLException, IOException {
        if (this.props == null || force) {
            this.props = new Properties();
            this.props.load(new URL(PROPERTY_URL_VALUE).openStream());
        }
    }

    public void gatherProperties() throws MalformedURLException, IOException {
        this.gatherProperties(false);
    }

    public void setLatestKnownVersion(Properties props) {
        this.latestKnownVersion = props.getProperty(LATEST_KNOWN_VERSION_PROPERTY_NAME, LATEST_KNOWN_VERSION_VALUE);
    }

    public String whatIsTheLastestVersion() throws MalformedURLException, IOException {
        try {
            this.gatherProperties(true);
        }
        catch (IOException ioe) {
            URL u = new URL(PROPERTY_URL_VALUE);
            throw new IOException("Cannot connect to " + u.getHost());
        }
        return this.getProperties().getProperty(LATEST_KNOWN_VERSION_PROPERTY_NAME_EXTERNALLY, LATEST_KNOWN_VERSION_VALUE);
    }

    public String whatIsTheDownloadURL() throws MalformedURLException, IOException {
        this.gatherProperties();
        return this.getProperties().getProperty(DOWNLOAD_URL_PROPERTY_NAME_EXTERNALLY, DOWNLOAD_URL_VALUE);
    }
}

