/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.calendarlistformats;

import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.numericalchameleon.util.calendarlistformats.ListFormat;

public class TWikiCalendarListFormat
extends ListFormat {
    private Format formatter = new SimpleDateFormat("dd MMM yyyy");

    @Override
    public String getHeader() {
        String weekstartsonmonday = "";
        if (Locale.getDefault().getCountry().equalsIgnoreCase("DE")) {
            weekstartsonmonday = "weekstartsonmonday=\"1\"";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String currentYear = format.format((Object)date);
        return "<!--\n    http://twiki.org/cgi-bin/view/Plugins/CalendarPlugin\n    http://foswiki.org/Extensions/CalendarPlugin\n-->\n%CALENDAR{month=\"1\" year=\"" + currentYear + "\" months=\"12\" showweekdayheaders=\"1\" " + weekstartsonmonday + " cellalignment=\"left\" nowrap=\"1\"}%\n";
    }

    @Override
    public String getFooter() {
        return "";
    }

    @Override
    public String getFormat() {
        return "   * $TVALUE - %RED% $TFLAG: $TUNIT %ENDCOLOR%";
    }

    @Override
    public String reformatDate(int dateformat, String date) throws ParseException {
        Date newdate = DateFormat.getDateInstance(dateformat).parse(date);
        return this.formatter.format(newdate);
    }

    @Override
    public String reformatUnit(String unit) {
        return unit;
    }
}

