/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.datediff;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class LeapSeconds {
    private static ArrayList<Calendar> list;

    public static void readFile() {
        list = new ArrayList();
        try {
            String str;
            InputStream is = LeapSeconds.class.getResourceAsStream("/data/lists/leapseconds");
            BufferedReader in = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
            while ((str = in.readLine()) != null) {
                if (str.length() == 0 || str.startsWith("#")) continue;
                Calendar cal = LeapSeconds.process(str);
                list.add(cal);
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getLeapSeconds(Calendar start, Calendar end) {
        if (start.after(end)) {
            Calendar temp = start;
            start = end;
            end = temp;
        }
        if (list == null) {
            LeapSeconds.readFile();
        }
        int secs = 0;
        for (Calendar leap : list) {
            if (!start.before(leap) || !end.after(leap) && !end.equals(leap)) continue;
            ++secs;
        }
        return secs;
    }

    public static int getMonth(String month) {
        if (month.equalsIgnoreCase("Dec")) {
            return 11;
        }
        if (month.equalsIgnoreCase("Jun")) {
            return 5;
        }
        if (month.equalsIgnoreCase("Jan")) {
            return 0;
        }
        if (month.equalsIgnoreCase("Feb")) {
            return 1;
        }
        if (month.equalsIgnoreCase("Mar")) {
            return 2;
        }
        if (month.equalsIgnoreCase("Apr")) {
            return 3;
        }
        if (month.equalsIgnoreCase("May")) {
            return 4;
        }
        if (month.equalsIgnoreCase("Jul")) {
            return 6;
        }
        if (month.equalsIgnoreCase("Aug")) {
            return 7;
        }
        if (month.equalsIgnoreCase("Sep")) {
            return 8;
        }
        if (month.equalsIgnoreCase("Oct")) {
            return 9;
        }
        if (month.equalsIgnoreCase("Nov")) {
            return 10;
        }
        return -1;
    }

    public static Calendar process(String str) {
        try {
            String[] arr = str.split("\t");
            if (!arr[0].equalsIgnoreCase("Leap")) {
                return null;
            }
            int year = Integer.parseInt(arr[1]);
            int month = LeapSeconds.getMonth(arr[2]);
            int day = Integer.parseInt(arr[3]);
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, day);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 60);
            cal.set(14, 0);
            return cal;
        }
        catch (NumberFormatException e) {
            System.err.println(e);
            return null;
        }
    }
}

