/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class EsperantoNumber
extends SpokenNumber {
    private static final String[] field = new String[]{"nulo", "unu", "du", "tri", "kvar", "kvin", "ses", "sep", "ok", "na\u016d", "dek"};
    private static final String HUNDRED = "cent";
    private static final String AND = " ";
    private static final String MINUS = "minus";

    public EsperantoNumber() {
    }

    public EsperantoNumber(long number) throws Exception {
        super(number);
    }

    public EsperantoNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 3;
    }

    @Override
    public String getSoundDir() {
        return "esperanto";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("minus ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(field);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(field[0]);
        } else {
            this.decode(0);
        }
    }

    private void decode(int index) {
        int x = this.digits[index + 1] * 10 + this.digits[index];
        if (this.digits[index + 2] > 0) {
            if (this.digits[index + 2] > 1) {
                this.syllables.add(field[this.digits[index + 2]]);
            }
            if (x > 0) {
                this.syllables.add("cent ");
            } else {
                this.syllables.add(HUNDRED);
            }
        }
        if (x != 0) {
            if (x < 11) {
                this.syllables.add(field[x]);
            } else {
                if (this.digits[index + 1] > 1) {
                    this.syllables.add(field[this.digits[index + 1]]);
                    this.syllables.add(field[10]);
                } else {
                    this.syllables.add(field[10]);
                }
                if (this.digits[index] > 0) {
                    this.syllables.add(AND + field[this.digits[index]]);
                }
            }
        }
    }

    public static String toString(long number) throws Exception {
        return new EsperantoNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new EsperantoNumber(number).toString();
    }
}

