/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class HungarianNumber
extends SpokenNumber {
    private static final String MINUS = "m\u00ednusz";
    private static final String NULL = "nulla";
    private static final String[] _1to9 = new String[]{"egy", "kett\u0151", "h\u00e1rom", "n\u00e9gy", "\u00f6t", "hat", "h\u00e9t", "nyolc", "kilenc"};
    private static final String[] _10to90 = new String[]{"t\u00edz", "h\u00fasz", "harminc", "negyven", "\u00f6tven", "hatvan", "hetven", "nyolcvan", "kilencven"};
    private static final String[] _11to99PREFIX = new String[]{"tizen", "huszon", _10to90[2], _10to90[3], _10to90[4], _10to90[5], _10to90[6], _10to90[7], _10to90[8]};
    private static final String[] _100and1000PREFIX = new String[]{_1to9[0], "k\u00e9t", _1to9[2], _1to9[3], _1to9[4], _1to9[5], _1to9[6], _1to9[7], _1to9[8]};
    private static final String HUNDRED = "sz\u00e1z";
    private static final String[] LARGE = new String[]{"ezer", "milli\u00f3", "milli\u00e1rd", "billi\u00f3", "billi\u00e1rd", "trilli\u00f3", "trilli\u00e1rd"};

    public HungarianNumber() {
    }

    public HungarianNumber(long number) throws Exception {
        super(number);
    }

    public HungarianNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return LARGE.length * 3 + 3;
    }

    @Override
    public String getSoundDir() {
        return "hungarian";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("m\u00ednusz ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, _1to9);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
            return;
        }
        int counter = LARGE.length - 1;
        for (int i = this.getSupportedDigits() - 3; i > 0; i -= 3) {
            this.xtriple(i, LARGE[counter]);
            --counter;
        }
        this.triple(0);
    }

    private void xtriple(int index, String x) {
        int sum = this.digits[index + 2] * 100 + this.digits[index + 1] * 10 + this.digits[index];
        int ff = 0;
        for (int i = 0; i < index; ++i) {
            ff += this.digits[i];
        }
        if (sum > 0) {
            this.triple(index);
            this.syllables.add(x);
            if (sum > 1 && ff > 0) {
                this.syllables.add("-");
            }
        }
    }

    private void triple(int index) {
        String[] prefix = index == 0 ? _1to9 : _100and1000PREFIX;
        if (this.digits[index + 2] > 0) {
            this.syllables.add(_100and1000PREFIX[this.digits[index + 2] - 1]);
            this.syllables.add(HUNDRED);
        }
        if (this.digits[index + 1] > 0 && this.digits[index + 0] == 0) {
            this.syllables.add(_10to90[this.digits[index + 1] - 1]);
        }
        if (this.digits[index + 1] > 0 && this.digits[index + 0] > 0) {
            this.syllables.add(_11to99PREFIX[this.digits[index + 1] - 1]);
            this.syllables.add(prefix[this.digits[index + 0] - 1]);
        }
        if (this.digits[index + 1] == 0 && this.digits[index + 0] > 0) {
            this.syllables.add(prefix[this.digits[index + 0] - 1]);
        }
    }

    public static String toString(long number) throws Exception {
        return new HungarianNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new HungarianNumber(number).toString();
    }
}

