/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class IndianTamilNumber
extends SpokenNumber {
    private static final String[] field = new String[]{"onru", "irantu", "m\u016bnru", "n\u0101nku", "aintu", "\u0101ru", "\u0113lu", "ettu", "onpatu"};
    private static final String NULL = "chuliyam";
    private static final String MINUS = "-";

    public IndianTamilNumber() {
    }

    public IndianTamilNumber(long number) throws Exception {
        super(number);
    }

    public IndianTamilNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 1;
    }

    @Override
    public String getSoundDir() {
        return "tamil";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("- ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
        } else {
            this.syllables.add(field[this.digits[0] - 1]);
        }
    }

    public static String toString(long number) throws Exception {
        return new IndianTamilNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new IndianTamilNumber(number).toString();
    }
}

