/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class TonganNumber
extends SpokenNumber {
    private static final String[] field = new String[]{"noa", "taha", "ua", "tolu", "fa", "nima", "ono", "fitu", "valu", "hiva"};
    private static final String MINUS = "-";

    public TonganNumber() {
    }

    public TonganNumber(long number) throws Exception {
        super(number);
    }

    public TonganNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 100;
    }

    @Override
    public String getSoundDir() {
        return "tongan";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("- ");
        }
        this.fillSyllables(field);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.syllables.size(); ++i) {
            sb.append(((String)this.syllables.get(i)).toString());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public static String toString(long number) throws Exception {
        return new TonganNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new TonganNumber(number).toString();
    }
}

