/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.UKEnglishNumber;

public class USEnglishNumber
extends UKEnglishNumber {
    private static final String[] amountUS = new String[]{"thousand", "million", "billion", "trillion", "quadrillion", "quintillion", "sextillion", "septillion", "octillion", "nonillion", "decillion", "undecillion", "duodecillion", "tredecillion", "quattuordecillion", "quindecillion", "sexdecillion", "septendecillon", "octodecillion", "novemdecillion", "vigintillion", "unvigintillion", "dovigintillion", "trevigintillion", "quattuorvigintillion", "quinvigintillion", "sexvigintillion", "septenvigintillion", "octovigintillion", "novemvigintillion", "trigintillion"};

    @Override
    protected void convert2Syllables() throws Exception {
        this.convert2Syllables(amountUS);
    }

    public USEnglishNumber() {
    }

    public USEnglishNumber(long number) throws Exception {
        super(number);
    }

    public USEnglishNumber(String number) throws Exception {
        super(number);
    }

    @Override
    public String getSoundDir() {
        return "us_english";
    }

    @Override
    protected void triple(int index) {
        if (this.digits[index + 2] > 0) {
            this.syllables.add(field[0][this.digits[index + 2] - 1]);
            this.syllables.add("hundred");
        }
        if (this.digits[index + 1] == 1 && this.digits[index] > 0) {
            this.syllables.add(field[1][this.digits[index] - 1]);
        } else if (this.digits[index + 1] >= 1 && this.digits[index] == 0) {
            this.syllables.add(field[2][this.digits[index + 1] - 1]);
        } else {
            if (this.digits[index + 1] > 0) {
                this.syllables.add(field[2][this.digits[index + 1] - 1]);
                if (this.digits[index] > 0) {
                    this.syllables.add("-");
                }
            }
            if (this.digits[index] > 0) {
                this.syllables.add(field[0][this.digits[index] - 1]);
            }
        }
    }

    public static String toString(long number) throws Exception {
        return new USEnglishNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new USEnglishNumber(number).toString();
    }
}

