/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokentime;

import net.numericalchameleon.util.spokennumbers.GermanNumber;
import net.numericalchameleon.util.spokennumbers.GermanSwitzerlandNumber;
import net.numericalchameleon.util.spokentime.MilitaryTime;
import net.numericalchameleon.util.spokentime.MilitaryTimeInterface;
import net.numericalchameleon.util.spokentime.NumberToWordsInterface;
import net.numericalchameleon.util.spokentime.SpokenTime;

public class GermanTime
extends SpokenTime
implements NumberToWordsInterface,
MilitaryTimeInterface {
    private static final String MINUTE = "Minute";
    private static final String MINUTES = "Minuten";
    private static final String UHR = "Uhr";
    private static final String UND = "und";
    private static final String BLANK = " ";
    private static final String HUNDERT = "Hundert";
    private static final String VIERTEL = "Viertel";
    private static final String DREIVIERTEL = "Dreiviertel";
    private static final String Halb = "Halb";
    private static final String halb = "halb";
    private static final String NACH = "nach";
    private static final String VOR = "vor";
    private static final String AB = "ab";
    private final HourclockType type;

    public GermanTime(HourclockType hourclock) {
        this.type = hourclock;
    }

    private void hourclock24_normal() {
        if (this.hours == 1) {
            this.syllables.add("ein");
        } else {
            this.hoursInWords(this.hours);
        }
        this.syllables.add(BLANK);
        this.syllables.add(UHR);
        if (this.minutes == 0) {
            return;
        }
        this.syllables.add(BLANK);
        this.minutesInWords(this.minutes);
    }

    private void hourclock24_formal() {
        if (this.hours == 1) {
            this.syllables.add("ein");
        } else {
            this.hoursInWords(this.hours);
        }
        this.syllables.add(BLANK);
        this.syllables.add(UHR);
        if (this.minutes == 0) {
            return;
        }
        this.syllables.add(BLANK);
        this.syllables.add(UND);
        this.syllables.add(BLANK);
        if (this.minutes == 1) {
            this.syllables.add("eine");
        } else {
            this.minutesInWords(this.minutes);
        }
        this.syllables.add(BLANK);
        this.syllables.add(this.minutes == 1 ? MINUTE : MINUTES);
    }

    private void hourclock24_military() {
        MilitaryTime mt = new MilitaryTime(this, this.hours, this.minutes);
    }

    private void hourclock12() {
        if (this.minutes == 0) {
            this.hoursInWords(this.hours);
        } else if (this.minutes == 15) {
            if (this.type == HourclockType.HOURCLOCK12_VARIANT1_DE || this.type == HourclockType.HOURCLOCK12_VARIANT3_DE) {
                this.syllables.add(VIERTEL);
                this.syllables.add(BLANK);
                this.syllables.add(NACH);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours);
            } else if (this.type == HourclockType.HOURCLOCK12_VARIANT2_DE || this.type == HourclockType.HOURCLOCK12_VARIANT4_DE) {
                this.syllables.add(VIERTEL);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours + 1);
            } else if (this.type == HourclockType.HOURCLOCK12_VARIANT1_CH) {
                this.syllables.add(VIERTEL);
                this.syllables.add(BLANK);
                this.syllables.add(AB);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours);
            }
        } else if (this.minutes == 30) {
            this.syllables.add(Halb);
            this.syllables.add(BLANK);
            this.hoursInWords(this.hours + 1);
        } else if (this.minutes == 45) {
            if (this.type == HourclockType.HOURCLOCK12_VARIANT1_DE || this.type == HourclockType.HOURCLOCK12_VARIANT3_DE || this.type == HourclockType.HOURCLOCK12_VARIANT1_CH) {
                this.syllables.add(VIERTEL);
                this.syllables.add(BLANK);
                this.syllables.add(VOR);
            } else if (this.type == HourclockType.HOURCLOCK12_VARIANT2_DE || this.type == HourclockType.HOURCLOCK12_VARIANT4_DE) {
                this.syllables.add(DREIVIERTEL);
            }
            this.syllables.add(BLANK);
            this.hoursInWords(this.hours + 1);
        } else if (this.minutes >= 25 && this.minutes < 30) {
            this.minutesInWords(30 - this.minutes);
            this.syllables.add(BLANK);
            this.syllables.add(VOR);
            this.syllables.add(BLANK);
            this.syllables.add(halb);
            this.syllables.add(BLANK);
            this.hoursInWords(this.hours + 1);
        } else if (this.minutes >= 20 && this.minutes < 25) {
            if (this.type == HourclockType.HOURCLOCK12_VARIANT1_DE || this.type == HourclockType.HOURCLOCK12_VARIANT4_DE) {
                this.minutesInWords(this.minutes);
                this.syllables.add(BLANK);
                this.syllables.add(NACH);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours);
            } else if (this.type == HourclockType.HOURCLOCK12_VARIANT2_DE || this.type == HourclockType.HOURCLOCK12_VARIANT3_DE) {
                this.minutesInWords(30 - this.minutes);
                this.syllables.add(BLANK);
                this.syllables.add(VOR);
                this.syllables.add(BLANK);
                this.syllables.add(halb);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours + 1);
            } else if (this.type == HourclockType.HOURCLOCK12_VARIANT1_CH) {
                this.minutesInWords(this.minutes);
                this.syllables.add(BLANK);
                this.syllables.add(AB);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours);
            }
        } else if (this.minutes > 30 && this.minutes <= 35) {
            this.minutesInWords(this.minutes - 30);
            this.syllables.add(BLANK);
            this.syllables.add(NACH);
            this.syllables.add(BLANK);
            this.syllables.add(halb);
            this.syllables.add(BLANK);
            this.hoursInWords(this.hours + 1);
        } else if (this.minutes > 35 && this.minutes <= 40) {
            if (this.type == HourclockType.HOURCLOCK12_VARIANT1_DE || this.type == HourclockType.HOURCLOCK12_VARIANT4_DE || this.type == HourclockType.HOURCLOCK12_VARIANT1_CH) {
                this.minutesInWords(60 - this.minutes);
                this.syllables.add(BLANK);
                this.syllables.add(VOR);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours + 1);
            } else if (this.type == HourclockType.HOURCLOCK12_VARIANT2_DE || this.type == HourclockType.HOURCLOCK12_VARIANT3_DE) {
                this.minutesInWords(this.minutes - 30);
                this.syllables.add(BLANK);
                this.syllables.add(NACH);
                this.syllables.add(BLANK);
                this.syllables.add(halb);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours + 1);
            }
        } else if (this.minutes > 40) {
            this.minutesInWords(60 - this.minutes);
            this.syllables.add(BLANK);
            this.syllables.add(VOR);
            this.syllables.add(BLANK);
            this.hoursInWords(this.hours + 1);
        } else if (this.minutes < 20) {
            if (this.type == HourclockType.HOURCLOCK12_VARIANT1_CH) {
                this.minutesInWords(this.minutes);
                this.syllables.add(BLANK);
                this.syllables.add(AB);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours);
            } else {
                this.minutesInWords(this.minutes);
                this.syllables.add(BLANK);
                this.syllables.add(NACH);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours);
            }
        }
    }

    @Override
    public void init() {
        this.syllables.clear();
        try {
            switch (this.type) {
                case HOURCLOCK12_VARIANT1_DE: 
                case HOURCLOCK12_VARIANT2_DE: 
                case HOURCLOCK12_VARIANT3_DE: 
                case HOURCLOCK12_VARIANT4_DE: 
                case HOURCLOCK12_VARIANT1_CH: {
                    this.hourclock12();
                    break;
                }
                case HOURCLOCK12_VARIANT0_DE: 
                case HOURCLOCK24_DE: 
                case HOURCLOCK24_CH: {
                    this.hourclock24_normal();
                    break;
                }
                case HOURCLOCK24_FORMAL_DE: 
                case HOURCLOCK24_FORMAL_CH: {
                    this.hourclock24_formal();
                    break;
                }
                case HOURCLOCK24_MILITARY_DE: 
                case HOURCLOCK24_MILITARY_CH: {
                    this.hourclock24_military();
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void hoursInWords(int hours) {
        int h = hours;
        if (this.type.getHours() == 12) {
            if (h >= 12) {
                h -= 12;
            }
            if (h == 0) {
                h = 12;
            }
        }
        this.numberToWords(h);
    }

    public void minutesInWords(int minutes) {
        this.numberToWords(minutes);
    }

    @Override
    public void numberToWords(int number) {
        try {
            if (this.type.getCountry() == Country.DE || this.type.getCountry() == Country.AT) {
                GermanNumber germanNumber = new GermanNumber(number);
                this.syllables.addAll(germanNumber.getSyllables());
                return;
            }
            if (this.type.getCountry() != Country.CH) {
                throw new IllegalArgumentException((Object)((Object)this.type) + " is not supported");
            }
            GermanSwitzerlandNumber germanSwitzerlandNumber = new GermanSwitzerlandNumber(number);
            this.syllables.addAll(germanSwitzerlandNumber.getSyllables());
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    @Override
    public String getSoundDir() {
        return "german";
    }

    @Override
    public String timeInWords() {
        StringBuilder sb = new StringBuilder();
        for (String syllable : this.syllables) {
            sb.append(syllable);
        }
        return sb.toString();
    }

    @Override
    public void hundredString() {
        this.syllables.add(HUNDERT);
    }

    @Override
    public void separator() {
        this.syllables.add(BLANK);
    }

    public static enum HourclockType {
        HOURCLOCK12_VARIANT1_DE(12, Country.DE),
        HOURCLOCK12_VARIANT2_DE(12, Country.DE),
        HOURCLOCK12_VARIANT3_DE(12, Country.DE),
        HOURCLOCK12_VARIANT4_DE(12, Country.DE),
        HOURCLOCK12_VARIANT0_DE(12, Country.DE),
        HOURCLOCK12_VARIANT1_CH(12, Country.CH),
        HOURCLOCK24_DE(24, Country.DE),
        HOURCLOCK24_FORMAL_DE(24, Country.DE),
        HOURCLOCK24_MILITARY_DE(24, Country.DE),
        HOURCLOCK24_CH(24, Country.CH),
        HOURCLOCK24_FORMAL_CH(24, Country.CH),
        HOURCLOCK24_MILITARY_CH(24, Country.CH);

        private final int hours;
        private final Country country;

        private HourclockType(int hours, Country country) {
            this.hours = hours;
            this.country = country;
        }

        public Country getCountry() {
            return this.country;
        }

        public int getHours() {
            return this.hours;
        }
    }

    public static enum Country {
        DE,
        CH,
        AT;

    }
}

