/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokentime;

import java.util.ArrayList;
import net.numericalchameleon.util.spokennumbers.AudioThread;

public abstract class SpokenAudio {
    protected AudioThread audioThread = null;
    protected ArrayList<String> syllables = new ArrayList();
    protected int waitAfterASyllable = 0;

    public abstract String getSoundDir();

    public void play() {
        String dir = this.getSoundDir();
        if (dir != null) {
            if (this.audioThread != null) {
                this.audioThread.interrupt();
                while (this.audioThread.isAlive()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.audioThread = new AudioThread(this.syllables, dir);
            this.audioThread.setWaitAfterASyllable(this.waitAfterASyllable);
            this.audioThread.start();
        }
    }

    public void stopPlaying() {
        if (this.audioThread != null) {
            this.audioThread.interrupt();
        }
    }
}

