/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.GregorianCalendar;

public class EgyptianCalendar
extends OldWorldCalendar {
    private final int J_FIRST;
    public static final int PSAMETIK = EgyptianCalendar.date2jdn_julian(-663, 2, 5);
    public static final int NABONASSAR = EgyptianCalendar.date2jdn_julian(-746, 2, 26);
    public static final int CENSORINUS = EgyptianCalendar.date2jdn_julian(139, 7, 20);
    public static final int CENSORINUS_1 = CENSORINUS - 533265;
    public static final int CENSORINUS_2 = CENSORINUS - 1066530;
    public static final int CENSORINUS_3;
    public static final int FIRST_JULIAN_DAY;
    private static final long serialVersionUID = 1L;

    public EgyptianCalendar() {
        this(EgyptianCalendar.getToday());
    }

    public EgyptianCalendar(int n, int n2, int n3) {
        this(n, n2, n3, CENSORINUS_3);
    }

    public EgyptianCalendar(int n, int n2) {
        this.J_FIRST = CENSORINUS_3;
        this.set(n, n2);
    }

    public EgyptianCalendar(int n) {
        this.J_FIRST = CENSORINUS_3;
        this.set(n);
    }

    public EgyptianCalendar(Calendar calendar) {
        this(calendar, CENSORINUS_3);
    }

    public EgyptianCalendar(GregorianCalendar gregorianCalendar) {
        this(gregorianCalendar, CENSORINUS_3);
    }

    public EgyptianCalendar(int n, int n2, int n3, int n4) {
        this.J_FIRST = n4;
        this.checkEpoch(n4);
        this.set(n, n2, n3);
    }

    public EgyptianCalendar(Calendar calendar, int n) {
        this.J_FIRST = n;
        this.checkEpoch(n);
        this.set(calendar);
    }

    public EgyptianCalendar(GregorianCalendar gregorianCalendar, int n) {
        this.J_FIRST = n;
        this.checkEpoch(n);
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < this.J_FIRST) {
            throw new IllegalArgumentException("EgyptianCalendar jdn2date (int n)");
        }
        int n2 = n - this.J_FIRST;
        int n3 = n2 / 365;
        this.doy2date(n3 + 1, n2 - 365 * n3 + 1);
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        return this.J_FIRST - 1 + 365 * (n - 1) + this.getCumulativeDays(n, n2 - 1) + n3;
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (!this.isDate(n, n2)) {
            throw new IllegalArgumentException("doy2date year=" + n + " doy=" + n2);
        }
        this.year = n;
        this.month = (n2 - 1) / 30 + 1;
        this.day = n2 - this.getCumulativeDays(n, this.month - 1);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("EgyptianCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return n2 < 13 ? 30 * n2 : 365;
    }

    @Override
    public boolean isLeapYear(int n) {
        return false;
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return n2 < 13 ? 30 : 5;
    }

    @Override
    public int getLastMonthOfYear(int n) {
        return 13;
    }

    @Override
    public int getDayOfWeek() {
        return EgyptianCalendar.amod(this.getDay(), 10);
    }

    private final void checkEpoch(int n) {
        if (n != PSAMETIK && n != NABONASSAR && n != CENSORINUS && n != CENSORINUS_1 && n != CENSORINUS_2 && n != CENSORINUS_3) {
            throw new IllegalArgumentException("checkEpoch epoch=" + n);
        }
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }

    static {
        FIRST_JULIAN_DAY = CENSORINUS_3 = CENSORINUS - 1599795;
    }
}

