/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import java.util.GregorianCalendar;

public class MayanCalendar
extends Calendar {
    private int baktun;
    private int katun;
    private int tun;
    private int uinal;
    private int kin;
    private int haabDay;
    private int haabMonth;
    private int tzolkinDay;
    private int tzolkinMonth;
    private final int J_FIRST;
    public static final int GOODMAN_OLD = 584285;
    public static final int GOODMAN = 584283;
    public static final int SPINDEN = 489384;
    public static final int HOCHLEITNER = 578585;
    private static final int BAKTUN = 144000;
    private static final int KATUN = 7200;
    private static final int TUN = 360;
    private static final int UINAL = 20;
    private static final int FIRST_HAAB_DAY = 8;
    private static final int FIRST_HAAB_MONTH = 18;
    private static final int FIRST_TZOLKIN_DAY = 4;
    private static final int FIRST_TZOLKIN_MONTH = 20;
    private int H0;
    private int TD;
    private int TM;
    public static final int FIRST_JULIAN_DAY = 584283;
    private static final long serialVersionUID = 1L;

    public MayanCalendar() {
        this(MayanCalendar.getToday());
    }

    public MayanCalendar(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 584283);
    }

    public MayanCalendar(int n) {
        this(n, 584283);
    }

    public MayanCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        this.J_FIRST = n6;
        this.checkEpoch(n6);
        this.set(n, n2, n3, n4, n5);
    }

    public MayanCalendar(int n, int n2) {
        this.J_FIRST = n2;
        this.checkEpoch(n2);
        this.set(n);
    }

    public MayanCalendar(Calendar calendar) {
        this(calendar, 584283);
    }

    public MayanCalendar(GregorianCalendar gregorianCalendar) {
        this(gregorianCalendar, 584283);
    }

    public MayanCalendar(Calendar calendar, int n) {
        this.J_FIRST = n;
        this.checkEpoch(n);
        this.set(calendar);
    }

    public MayanCalendar(GregorianCalendar gregorianCalendar, int n) {
        this.J_FIRST = n;
        this.checkEpoch(n);
        this.set(gregorianCalendar);
    }

    @Override
    public int getBaktun() {
        return this.baktun;
    }

    @Override
    public int getKatun() {
        return this.katun;
    }

    @Override
    public int getTun() {
        return this.tun;
    }

    @Override
    public int getUinal() {
        return this.uinal;
    }

    @Override
    public int getKin() {
        return this.kin;
    }

    @Override
    public boolean isDate(int n, int n2, int n3, int n4, int n5) {
        return n >= 0 && 0 <= n2 && n2 <= 19 && 0 <= n3 && n3 <= 19 && 0 <= n4 && n4 <= 17 && 0 <= n5 && n5 <= 19;
    }

    @Override
    public String toString() {
        return this.baktun + "." + this.katun + "." + this.tun + "." + this.uinal + "." + this.kin;
    }

    @Override
    public void set(int n, int n2, int n3, int n4, int n5) {
        this.baktun = n;
        this.katun = n2;
        this.tun = n3;
        this.uinal = n4;
        this.kin = n5;
        this.jdn = this.date2jdn();
        this.set();
        this.ok("MayanCalendar (int baktun, ...");
    }

    @Override
    public void set(int n) {
        this.jdn2date(n);
        this.jdn = n;
        this.set();
        this.ok("Calendar set (int jd)");
    }

    @Override
    public int getHaabDay() {
        return this.haabDay;
    }

    @Override
    public int getHaabMonth() {
        return this.haabMonth;
    }

    @Override
    public int getTzolkinDay() {
        return this.tzolkinDay;
    }

    @Override
    public int getTzolkinMonth() {
        return this.tzolkinMonth;
    }

    private void set() {
        int n = (this.getJulianDayNumber() + this.H0 + 8 + 340) % 365;
        this.haabDay = n % 20;
        this.haabMonth = n / 20 + 1;
        this.tzolkinDay = MayanCalendar.amod(this.getJulianDayNumber() + 4 + this.TD, 13);
        this.tzolkinMonth = MayanCalendar.amod(this.getJulianDayNumber() + 20 + this.TM, 20);
    }

    @Override
    protected boolean ok(String string) {
        if (this.isDate(this.baktun, this.katun, this.tun, this.uinal, this.kin) && this.jdn >= this.J_FIRST) {
            return true;
        }
        throw new IllegalArgumentException(string + ":\n" + " baktun=" + this.baktun + " katun=" + this.katun + " tun=" + this.tun + " uinal=" + this.uinal + " kin=" + this.kin);
    }

    @Override
    protected int date2jdn() {
        return 144000 * this.baktun + 7200 * this.katun + 360 * this.tun + 20 * this.uinal + this.kin + this.J_FIRST;
    }

    @Override
    protected void jdn2date(int n) {
        if (n < this.J_FIRST) {
            throw new IllegalArgumentException("MayanCalendar jdn2date n=" + n);
        }
        this.baktun = (n - this.J_FIRST) / 144000;
        int n2 = (n - this.J_FIRST) % 144000;
        this.katun = n2 / 7200;
        int n3 = n2 % 7200;
        this.tun = n3 / 360;
        int n4 = n3 % 360;
        this.uinal = n4 / 20;
        this.kin = n4 % 20;
    }

    private final void checkEpoch(int n) {
        switch (n) {
            case 584285: {
                this.H0 = 80;
                this.TD = 0;
                this.TM = 15;
                break;
            }
            case 584283: {
                this.H0 = 82;
                this.TD = 2;
                this.TM = 17;
                break;
            }
            case 489384: {
                this.H0 = 81;
                this.TD = 1;
                this.TM = 16;
                break;
            }
            case 578585: {
                this.H0 = 305;
                this.TD = 19;
                this.TM = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("checkEpoch epoch=" + n);
            }
        }
    }

    @Override
    public int getFirstJulianDay() {
        return 584283;
    }
}

