/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.YMD;

abstract class OldWorldCalendar
extends YMD {
    protected static final int D400 = 146097;
    protected static final int D100 = 36524;
    protected static final int D4 = 1461;

    OldWorldCalendar() {
    }

    @Override
    public int getDayOfWeek() {
        int n = (this.getJulianDayNumber() + 1) % 7;
        return n == 0 ? 7 : n;
    }

    @Override
    public final int getDayOfYear() {
        return this.date2doy();
    }

    @Override
    public final boolean isLeapYear() {
        return this.isLeapYear(this.getYear());
    }

    @Override
    public boolean isDate(int n, int n2, int n3) {
        return n > 0 && 1 <= n2 && n2 <= this.getLastMonthOfYear(n) && 1 <= n3 && n3 <= this.getLengthOfMonth(n, n2);
    }

    @Override
    public boolean isDate(int n, int n2) {
        return n > 0 && 1 <= n2 && n2 <= this.getLengthOfYear(n);
    }

    @Override
    public void set(int n, int n2, int n3) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.jdn = this.date2jdn(this.getYear(), this.getMonth(), this.getDay());
        this.ok("OldWorldCalendar set (int year, int month, int day)");
    }

    @Override
    public void set(int n, int n2) {
        this.year = n;
        this.doy2date(n, n2);
        this.jdn = this.date2jdn(this.getYear(), this.getMonth(), this.getDay());
        this.ok("OldWorldCalendar set (int year=" + n + ", int doy=" + n2 + ")");
    }

    @Override
    protected boolean ok(String string) {
        if (this.isDate(this.getYear(), this.getMonth(), this.getDay())) {
            return true;
        }
        throw new IllegalArgumentException(string + ":\n" + " year=" + this.getYear() + " month=" + this.getMonth() + " day=" + this.getDay() + " jdn=" + this.getJulianDayNumber());
    }

    @Override
    protected int date2jdn() {
        return this.date2jdn(this.getYear(), this.getMonth(), this.getDay());
    }

    protected int date2doy() {
        return this.getCumulativeDays(this.getYear(), this.getMonth() - 1) + this.getDay();
    }

    @Override
    public int getLengthOfYear(int n) {
        return this.getCumulativeDays(n, this.getLastMonthOfYear(n));
    }

    @Override
    public int getFirstMonthOfYear(int n) {
        return 1;
    }

    @Override
    public int getLastMonthOfYear(int n) {
        return 12;
    }

    @Override
    public int getFirstDayOfMonth(int n, int n2) {
        return 1;
    }

    @Override
    public int getLastDayOfMonth(int n, int n2) {
        return this.getLengthOfMonth(n, n2);
    }

    private final void jdn(int n, int n2) {
        int n3 = (4 * n2 + 3) / 1461;
        int n4 = n2 - 1461 * n3 / 4;
        int n5 = (5 * n4 + 2) / 153;
        this.year = 100 * n + n3 - 4800 + n5 / 10;
        this.month = n5 + 3 - 12 * (n5 / 10);
        this.day = n4 - (153 * n5 + 2) / 5 + 1;
    }

    protected final void jdn2date_gregorian(int n) {
        int n2 = n + 32044;
        int n3 = (4 * n2 + 3) / 146097;
        int n4 = n2 - 146097 * n3 / 4;
        this.jdn(n3, n4);
    }

    protected final void jdn2date_julian(int n) {
        this.jdn(0, n + 32082);
    }

    protected void jdn2ymd(int n, int n2) {
        int n3 = n2 / 146097;
        int n4 = OldWorldCalendar.amod(n2 + 1, 146097);
        int n5 = Math.min(3, (n4 - 1) / 36524);
        int n6 = n4 - 36524 * n5;
        int n7 = (n6 - 1) / 1461;
        int n8 = OldWorldCalendar.amod(n6, 1461);
        int n9 = Math.min(3, (n8 - 1) / 365);
        int n10 = n8 - 365 * n9;
        this.doy2date(n + 400 * n3 + 100 * n5 + 4 * n7 + n9 + 1, n10);
    }
}

