/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.GregorianCalendar;

public class PersianCalendar
extends OldWorldCalendar {
    private static final int[] cumulative_days_in_ordinary_year = new int[]{0, 31, 62, 93, 124, 155, 186, 216, 246, 276, 306, 336, 365};
    private static final int[] cumulative_days_in_leap_year = new int[]{0, 31, 62, 93, 124, 155, 186, 216, 246, 276, 306, 336, 366};
    private static final int[] days_in_month_in_ordinary_year = new int[]{0, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29};
    private static final int[] days_in_month_in_leap_year = new int[]{0, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 30};
    private static final int D2820 = 1029983;
    private static final int D2816 = 1028522;
    private static final int D128 = 46751;
    private static final int D33 = 12053;
    private static final int D29 = 10592;
    private static final int D4 = 1461;
    public static final int FIRST_JULIAN_DAY = PersianCalendar.date2jdn_julian(622, 3, 19);
    private static final long serialVersionUID = 1L;

    public PersianCalendar() {
        this(PersianCalendar.getToday());
    }

    public PersianCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public PersianCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public PersianCalendar(int n) {
        this.set(n);
    }

    public PersianCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public PersianCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("PersianCalendar jdn2date (int n)");
        }
        int n2 = n - FIRST_JULIAN_DAY;
        int n3 = n2 / 1029983;
        int n4 = n2 % 1029983;
        int n5 = 2820 * n3;
        if (n4 >= 1028522) {
            int n6 = n4 - 1028522;
            int n7 = n6 / 365;
            int n8 = n6 % 365;
            int n9 = n5 + 2816 + n7;
            if (n6 == 1460) {
                this.year = n9;
                this.month = 12;
                this.day = 30;
            } else {
                this.doy2date(n9 + 1, n8 + 1);
            }
        } else {
            int n10 = n4 / 46751;
            int n11 = n4 % 46751;
            int n12 = 128 * n10;
            if (n11 < 10592) {
                this.doy2date_29_33(n5 + n12 + 1, n11);
            } else {
                int n13 = n11 - 10592;
                int n14 = n13 / 12053;
                int n15 = n13 % 12053;
                this.doy2date_29_33(n5 + n12 + 33 * n14 + 30, n15);
            }
        }
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("PersianCalendar jdn2date year=" + this.year + " month=" + this.month + " day=" + this.day + " n=" + n);
        }
    }

    private final void doy2date_29_33(int n, int n2) {
        this.year = n;
        if (n2 < 365) {
            this.doy2date(this.year, n2 + 1);
        } else {
            int n3 = n2 - 365;
            int n4 = n3 / 1461;
            int n5 = n3 % 1461;
            int n6 = n5 / 365;
            int n7 = n5 % 365;
            int n8 = n + 4 * n4 + n6;
            if (n5 == 1460 && this.isLeapYear(n8)) {
                this.year = n8;
                this.month = 12;
                this.day = 30;
            } else {
                this.doy2date(n8 + 1, n7 + 1);
            }
        }
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        int n4 = (n - 2) / 2820;
        int n5 = PersianCalendar.amod(n - 1, 2820);
        int n6 = n5 / 128;
        int n7 = n5 % 128;
        int n8 = n7 <= 29 ? 0 : (n7 - 30) / 33;
        int n9 = n7 <= 29 ? (n7 - 1) / 4 : 7 + 8 * n8 + PersianCalendar.cycle(n7) / 4;
        int n10 = 683 * n4 + 31 * n6 + n9 + (n5 == 2820 ? 1 : 0);
        return FIRST_JULIAN_DAY + 365 * (n - 1) + n10 + this.getCumulativeDays(n, n2 - 1) + n3 - 1;
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (n2 < 1 || n2 > this.getLengthOfYear(n)) {
            throw new IllegalArgumentException("PersianCalendar doy2date year=" + n + " doy=" + n2);
        }
        this.year = n;
        this.month = n2 <= cumulative_days_in_ordinary_year[6] ? (n2 - 1) / 31 + 1 : (n2 - cumulative_days_in_ordinary_year[6] - 1) / 30 + 7;
        this.day = n2 - this.getCumulativeDays(n, this.month - 1);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("PersianCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return this.isLeapYear(n) ? cumulative_days_in_leap_year[n2] : cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        int n2 = PersianCalendar.amod(n, 2820);
        int n3 = PersianCalendar.amod(n2, 128);
        int n4 = n2 > 2816 ? n2 - 2784 : PersianCalendar.cycle(n3);
        return n4 != 0 && n4 % 4 == 0;
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return this.isLeapYear(n) ? days_in_month_in_leap_year[n2] : days_in_month_in_ordinary_year[n2];
    }

    private static final int cycle(int n) {
        return n <= 29 ? n - 1 : (n - 30) % 33;
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }
}

