/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.JulianGregorianCalendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.Arrays;
import java.util.GregorianCalendar;

public class WorldCalendar
extends OldWorldCalendar {
    private static final int[] cumulative_days_in_leap_year = new int[]{0, 31, 61, 91, 122, 152, 183, 214, 244, 274, 305, 335, 366};
    private static final int[] cumulative_days_in_ordinary_year = new int[]{0, 31, 61, 91, 122, 152, 182, 213, 243, 273, 304, 334, 365};
    private static final int[] days_in_month_in_leap_year = new int[]{0, 31, 30, 30, 31, 30, 31, 31, 30, 30, 31, 30, 31};
    private static final int[] days_in_month_in_ordinary_year = new int[]{0, 31, 30, 30, 31, 30, 30, 31, 30, 30, 31, 30, 31};
    public static final int FIRST_JULIAN_DAY = WorldCalendar.date2jdn_gregorian(1, 1, 1);
    private static final long serialVersionUID = 1L;

    public WorldCalendar() {
        this(WorldCalendar.getToday());
    }

    public WorldCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public WorldCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public WorldCalendar(int n) {
        this.set(n);
    }

    public WorldCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public WorldCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("WorldCalendar jdn2date (int n)");
        }
        this.jdn2ymd(0, n - FIRST_JULIAN_DAY);
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        return FIRST_JULIAN_DAY - 1 + 365 * (n - 1) + (n - 1) / 4 - (n - 1) / 100 + (n - 1) / 400 + this.getCumulativeDays(n, n2 - 1) + n3;
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (n2 < 1 || n2 > this.getLengthOfYear(n)) {
            throw new IllegalArgumentException("WorldCalendar doy2date year=" + n + " doy=" + n2);
        }
        this.year = n;
        int n3 = this.month = this.isLeapYear(this.year) ? Arrays.binarySearch(cumulative_days_in_leap_year, n2) : Arrays.binarySearch(cumulative_days_in_ordinary_year, n2);
        if (this.month < 0) {
            this.month = -this.month - 1;
        }
        this.day = n2 - this.getCumulativeDays(n, this.month - 1);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("WorldCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    public int getDayOfWeek() {
        int n = this.getDayOfYear();
        if (this.isLeapYear()) {
            if (n == 183 || n == 366) {
                throw new IllegalArgumentException("WorldCalendar.getDayOfWeek");
            }
            return n < 183 ? WorldCalendar.amod(n + 6, 7) : WorldCalendar.amod(n + 5, 7);
        }
        if (n == 365) {
            throw new IllegalArgumentException("WorldCalendar.getDayOfWeek");
        }
        return WorldCalendar.amod(n + 6, 7);
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return this.isLeapYear(n) ? cumulative_days_in_leap_year[n2] : cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        return JulianGregorianCalendar.is_leap_year_gregorian(n);
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return this.isLeapYear(n) ? days_in_month_in_leap_year[n2] : days_in_month_in_ordinary_year[n2];
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }
}

