/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.chinese;

import fi.joensuu.joyds1.calendar.chinese.MoonPhase;
import fi.joensuu.joyds1.calendar.chinese.Novas;

public final class SolarSystem {
    private double tlast = 0.0;
    private double sine;
    private double cose;
    private double tmass;
    private double[] pbary = new double[3];
    private double[] vbary = new double[3];
    private double ra;
    private double dec;
    private double dis;
    private static final sun_con[] con = new sun_con[]{new sun_con(403406.0, 0.0, 4.721964, 1.621043), new sun_con(195207.0, -97597.0, 5.937458, 62830.348067), new sun_con(119433.0, -59715.0, 1.115589, 62830.821524), new sun_con(112392.0, -56188.0, 5.781616, 62829.634302), new sun_con(3891.0, -1556.0, 5.5474, 125660.5691), new sun_con(2819.0, -1126.0, 1.512, 125660.9845), new sun_con(1721.0, -861.0, 4.1897, 62832.4766), new sun_con(0.0, 941.0, 1.163, 0.813), new sun_con(660.0, -264.0, 5.415, 125659.31), new sun_con(350.0, -163.0, 4.315, 57533.85), new sun_con(334.0, 0.0, 4.553, -33.931), new sun_con(314.0, 309.0, 5.198, 777137.715), new sun_con(268.0, -158.0, 5.989, 78604.191), new sun_con(242.0, 0.0, 2.911, 5.412), new sun_con(234.0, -54.0, 1.423, 39302.098), new sun_con(158.0, 0.0, 0.061, -34.861), new sun_con(132.0, -93.0, 2.317, 115067.698), new sun_con(129.0, -20.0, 3.193, 15774.337), new sun_con(114.0, 0.0, 2.828, 5296.67), new sun_con(99.0, -47.0, 0.52, 58849.27), new sun_con(93.0, 0.0, 4.65, 5296.11), new sun_con(86.0, 0.0, 4.35, -3980.7), new sun_con(78.0, -33.0, 2.75, 52237.69), new sun_con(72.0, -32.0, 4.5, 55076.47), new sun_con(68.0, 0.0, 3.23, 261.08), new sun_con(64.0, -10.0, 1.22, 15773.85), new sun_con(46.0, -16.0, 0.14, 188491.03), new sun_con(38.0, 0.0, 3.44, -7756.55), new sun_con(37.0, 0.0, 4.37, 264.89), new sun_con(32.0, -24.0, 1.14, 117906.27), new sun_con(29.0, -13.0, 2.84, 55075.75), new sun_con(28.0, 0.0, 5.96, -7961.39), new sun_con(27.0, -9.0, 5.09, 188489.81), new sun_con(27.0, 0.0, 1.72, 2132.19), new sun_con(25.0, -17.0, 2.56, 109771.03), new sun_con(24.0, -11.0, 1.92, 54868.56), new sun_con(21.0, 0.0, 0.09, 25443.93), new sun_con(21.0, 31.0, 5.98, -55731.43), new sun_con(20.0, -10.0, 4.03, 60697.74), new sun_con(18.0, 0.0, 4.27, 2132.79), new sun_con(17.0, -12.0, 0.79, 109771.63), new sun_con(14.0, 0.0, 4.24, -7752.82), new sun_con(13.0, -5.0, 2.01, 188491.91), new sun_con(13.0, 0.0, 2.65, 207.81), new sun_con(13.0, 0.0, 4.98, 29424.63), new sun_con(12.0, 0.0, 0.93, -7.99), new sun_con(10.0, 0.0, 2.21, 46941.14), new sun_con(10.0, 0.0, 3.59, -68.29), new sun_con(10.0, 0.0, 1.5, 21463.25), new sun_con(10.0, -9.0, 2.55, 157208.4)};

    final int solarsystem(double d, int n, int n2, double[] dArray, double[] dArray2) {
        int n3;
        int n4 = 0;
        double[] dArray3 = new double[]{1047.349, 3497.898, 22903.0, 19412.2};
        double[] dArray4 = new double[]{5.203363, 9.53707, 19.191264, 30.068963};
        double[] dArray5 = new double[]{0.60047, 0.871693, 5.466933, 5.32116};
        double[] dArray6 = new double[]{0.001450138, 5.841727E-4, 2.047497E-4, 1.043891E-4};
        double[] dArray7 = new double[3];
        double[][] dArray8 = new double[3][3];
        if (this.tlast == 0.0) {
            double d2 = 0.40909280420293637;
            this.sine = Math.sin(d2);
            this.cose = Math.cos(d2);
            this.tmass = 1.0;
            for (n3 = 0; n3 < 4; ++n3) {
                this.tmass += 1.0 / dArray3[n3];
            }
            this.tlast = 1.0;
        }
        if (n == 0 || n == 1 || n == 10) {
            for (n3 = 0; n3 < 3; ++n3) {
                dArray2[n3] = 0.0;
                dArray[n3] = 0.0;
            }
        } else if (n == 2 || n == 3) {
            for (n3 = 0; n3 < 3; ++n3) {
                double d3 = d + (double)(n3 - 1) * 0.1;
                this.sun_eph(d3);
                SolarSystem.radec2vector(this.ra, this.dec, this.dis, dArray7);
                Novas.precession(d3, dArray7, 2451545.0, dArray);
                dArray8[n3][0] = -dArray[0];
                dArray8[n3][1] = -dArray[1];
                dArray8[n3][2] = -dArray[2];
            }
            for (n3 = 0; n3 < 3; ++n3) {
                dArray[n3] = dArray8[1][n3];
                dArray2[n3] = (dArray8[2][n3] - dArray8[0][n3]) / 0.2;
            }
        } else {
            n4 = 2;
            return 2;
        }
        if (n2 == 0) {
            if (Math.abs(d - this.tlast) >= 1.0E-6) {
                for (n3 = 0; n3 < 3; ++n3) {
                    this.vbary[n3] = 0.0;
                    this.pbary[n3] = 0.0;
                }
                for (n3 = 0; n3 < 4; ++n3) {
                    double d4 = dArray5[n3] + dArray6[n3] * (d - 2451545.0);
                    d4 = MoonPhase.fmod(d4, Math.PI * 2);
                    double d5 = Math.sin(d4);
                    double d6 = Math.cos(d4);
                    double d7 = dArray4[n3] * d6;
                    double d8 = dArray4[n3] * d5 * this.cose;
                    double d9 = dArray4[n3] * d5 * this.sine;
                    double d10 = -dArray4[n3] * dArray6[n3] * d5;
                    double d11 = dArray4[n3] * dArray6[n3] * d6 * this.cose;
                    double d12 = dArray4[n3] * dArray6[n3] * d6 * this.sine;
                    double d13 = 1.0 / (dArray3[n3] * this.tmass);
                    this.pbary[0] = this.pbary[0] + d7 * d13;
                    this.pbary[1] = this.pbary[1] + d8 * d13;
                    this.pbary[2] = this.pbary[2] + d9 * d13;
                    this.vbary[0] = this.vbary[0] + d10 * d13;
                    this.vbary[1] = this.vbary[1] + d11 * d13;
                    this.vbary[2] = this.vbary[2] + d12 * d13;
                }
                this.tlast = d;
            }
            for (n3 = 0; n3 < 3; ++n3) {
                int n5 = n3;
                dArray[n5] = dArray[n5] - this.pbary[n3];
                int n6 = n3;
                dArray2[n6] = dArray2[n6] - this.vbary[n3];
            }
        }
        return n4;
    }

    private final void sun_eph(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = (d - 2451545.0) / 3652500.0;
        for (int i = 0; i < 50; ++i) {
            double d5 = SolarSystem.con[i].alpha + SolarSystem.con[i].nu * d4;
            d2 += SolarSystem.con[i].l * Math.sin(d5);
            d3 += SolarSystem.con[i].r * Math.cos(d5);
        }
        double d6 = 4.9353929 + 62833.196168 * d4 + 1.0E-7 * d2;
        if ((d6 = MoonPhase.fmod(d6, Math.PI * 2)) < 0.0) {
            d6 += Math.PI * 2;
        }
        double d7 = 0.0;
        this.dis = 1.0001026 + 1.0E-7 * d3;
        double d8 = d4 * 100.0;
        double d9 = d8 * d8;
        double d10 = (0.001813 * d9 * d8 - 5.9E-4 * d9 - 46.815 * d8 + 84381.448) / 206264.80624709636;
        double d11 = Math.sin(d6);
        this.ra = Math.atan2(Math.cos(d10) * d11, Math.cos(d6)) * 57.29577951308232;
        this.ra = MoonPhase.fmod(this.ra, 360.0);
        if (this.ra < 0.0) {
            this.ra += 360.0;
        }
        this.ra /= 15.0;
        this.dec = Math.asin(Math.sin(d10) * d11) * 57.29577951308232;
    }

    private static void radec2vector(double d, double d2, double d3, double[] dArray) {
        dArray[0] = d3 * Math.cos(Math.PI / 180 * d2) * Math.cos(0.2617993877991494 * d);
        dArray[1] = d3 * Math.cos(Math.PI / 180 * d2) * Math.sin(0.2617993877991494 * d);
        dArray[2] = d3 * Math.sin(Math.PI / 180 * d2);
    }

    private static final class sun_con {
        double l;
        double r;
        double alpha;
        double nu;

        sun_con(double d, double d2, double d3, double d4) {
            this.l = d;
            this.r = d2;
            this.alpha = d3;
            this.nu = d4;
        }
    }
}

