/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.jcalendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.CalendarMath;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.format.DateFormatSymbols;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    private JButton[] days;
    private JButton selectedDay;
    private int day;
    private Color oldDayBackgroundColor;
    private Color selectedColor;
    private Color colorRed;
    private Color colorBlue;
    private String[] dayNames;
    private Calendar calendar;
    private Calendar today;
    private Locale locale;
    private boolean initialized = false;
    private DateFormatSymbols format;
    private static final long serialVersionUID = 1L;

    public JDayChooser(Calendar calendar, DateFormatSymbols dateFormatSymbols) {
        this.format = dateFormatSymbols;
        this.locale = Locale.getDefault();
        this.days = new JButton[49];
        this.selectedDay = null;
        Calendar calendar2 = calendar;
        this.today = (Calendar)calendar2.clone();
        this.setLayout(new GridLayout(7, 7));
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                int n = j + 7 * i;
                if (i == 0) {
                    this.days[n] = new JButton(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void addMouseListener(MouseListener mouseListener) {
                        }

                        @Override
                        public boolean isFocusable() {
                            return false;
                        }
                    };
                    this.days[n].setBackground(new Color(180, 180, 200));
                } else {
                    this.days[n] = new JButton("x");
                    this.days[n].addActionListener(this);
                    this.days[n].addKeyListener(this);
                    this.days[n].addFocusListener(this);
                }
                this.days[n].setMargin(new Insets(0, 0, 0, 0));
                this.days[n].setFocusPainted(false);
                this.add(this.days[n]);
            }
        }
        this.init(calendar);
        this.setDay(calendar2.getDay());
        this.initialized = true;
    }

    protected void init(Calendar calendar) {
        int n;
        this.colorRed = new Color(164, 0, 0);
        this.colorBlue = new Color(0, 0, 164);
        JButton jButton = new JButton();
        this.oldDayBackgroundColor = jButton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        this.calendar = calendar;
        int n2 = n = 0;
        for (int i = 0; i < 7; ++i) {
            this.days[i].setText(this.format.getShortWeekdayName(n2 + 1));
            if (n2 == 6) {
                this.days[i].setForeground(this.colorRed);
            } else {
                this.days[i].setForeground(this.colorBlue);
            }
            if (n2 < 7) {
                ++n2;
                continue;
            }
            n2 -= 6;
        }
        this.drawDays();
    }

    protected void drawDays() {
        int n;
        Calendar calendar = (Calendar)this.calendar.clone();
        boolean bl = false;
        calendar.set(this.calendar.getYear(), this.calendar.getMonth(), this.calendar.getFirstDayOfMonth(this.calendar.getYear(), this.calendar.getMonth()));
        int n2 = calendar.getDayOfWeek() - 1;
        if (n2 < 0) {
            n2 += 7;
        }
        for (n = 0; n < n2; ++n) {
            this.days[n + 7].setVisible(false);
            this.days[n + 7].setText("");
        }
        int n3 = this.calendar.getMonth();
        int n4 = 0;
        Color color = this.getForeground();
        int n5 = calendar.getDay();
        while (n3 == calendar.getMonth()) {
            this.days[n + n4 + 7].setText(Integer.toString(calendar.getDay()));
            this.days[n + n4 + 7].setVisible(true);
            if (calendar.getYear() == this.today.getYear() && calendar.getDayOfYear() == this.today.getDayOfYear()) {
                this.days[n + n4 + 7].setForeground(this.colorRed);
            } else {
                this.days[n + n4 + 7].setForeground(color);
            }
            if (n4 + 1 == this.day) {
                this.days[n + n4 + 7].setBackground(this.selectedColor);
                this.selectedDay = this.days[n + n4 + 7];
            } else {
                this.days[n + n4 + 7].setBackground(this.oldDayBackgroundColor);
            }
            ++n4;
            calendar.addDays(1);
            ++n5;
        }
        for (n5 = n4 + n + 7; n5 < 49; ++n5) {
            this.days[n5].setVisible(false);
            this.days[n5].setText("");
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            this.init(this.calendar);
        }
    }

    public void setDay(int n) {
        int n2;
        int n3 = this.calendar.getFirstDayOfMonth(this.calendar.getYear(), this.calendar.getMonth());
        if (n < n3) {
            n = n3;
        }
        if (n > (n2 = this.calendar.getLastDayOfMonth(this.calendar.getYear(), this.calendar.getMonth()))) {
            n = n2;
        }
        int n4 = this.day;
        this.day = n;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        for (int i = 7; i < 49; ++i) {
            if (!this.days[i].getText().equals(Integer.toString(this.day))) continue;
            this.selectedDay = this.days[i];
            this.selectedDay.setBackground(this.selectedColor);
            break;
        }
        this.firePropertyChange("day", n4, this.day);
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int n) {
        CalendarMath.setMonth(this.calendar, n, false);
        this.setDay(this.day);
        this.drawDays();
    }

    public void setYear(int n) {
        CalendarMath.setYear(this.calendar, n, false);
        this.setDay(this.calendar.getDay());
        this.drawDays();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.setDay(this.calendar.getDay());
        this.drawDays();
    }

    @Override
    public void setFont(Font font) {
        if (this.days != null) {
            for (int i = 0; i < 49; ++i) {
                this.days[i].setFont(font);
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.days != null) {
            for (int i = 7; i < 49; ++i) {
                this.days[i].setForeground(color);
            }
            this.drawDays();
        }
    }

    @Override
    public String getName() {
        return "JDayChooser";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        int n = new Integer(string);
        this.setDay(n);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JButton jButton = (JButton)focusEvent.getSource();
        String string = jButton.getText();
        if (string != null && !string.equals("")) {
            this.actionPerformed(new ActionEvent(focusEvent.getSource(), 0, null));
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getKeyCode() == 38 ? -7 : (keyEvent.getKeyCode() == 40 ? 7 : (keyEvent.getKeyCode() == 37 ? -1 : (n = keyEvent.getKeyCode() == 39 ? 1 : 0)));
        if (n != 0) {
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                if (this.getComponent(i) != this.selectedDay) continue;
                if ((i += n) <= 7 || i >= this.days.length || !this.days[i].isVisible()) break;
                this.days[i].requestFocus();
                break;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int n = 0; n < this.days.length; n = (int)((short)(n + 1))) {
            if (this.days[n] == null) continue;
            this.days[n].setEnabled(bl);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JDayChooser");
        jFrame.getContentPane().add(new JDayChooser(new GregorianCalendar(), new DateFormatSymbols()));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

