/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.test;

import fi.joensuu.joyds1.calendar.BritishCalendar;
import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.ChineseCalendar;
import fi.joensuu.joyds1.calendar.FinnishCalendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.format.SimpleDateFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class TestDateFormat3 {
    public static void main(String[] stringArray) {
        TestDateFormat3.test0("31.12.2001", "d.M.y");
        TestDateFormat3.test0("31.1.2001", "d.M.y");
        TestDateFormat3.test0("2001-12-31", "y-M-d");
        TestDateFormat3.test0("2001-12-01", "y-M-d");
        TestDateFormat3.test0("2001-12-1", "y-M-d");
        TestDateFormat3.test0("12/31/2001", "M/d/y");
        TestDateFormat3.test1();
        TestDateFormat3.test2();
        TestDateFormat3.test3();
    }

    private static void test0(String string, String string2) {
        ParsePosition parsePosition = new ParsePosition(0);
        Calendar calendar = new GregorianCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        calendar = simpleDateFormat.parse(string, calendar, parsePosition);
        System.out.println(string + " " + string2 + " " + calendar.toString());
    }

    private static void test1() {
        Locale.setDefault(new Locale("fi", "FI"));
        String string = "31. tammikuuta 2001";
        ParsePosition parsePosition = new ParsePosition(0);
        Calendar calendar = new FinnishCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d. M y");
        calendar = simpleDateFormat.parse(string, calendar, parsePosition);
        System.out.println(string + " " + calendar.toString());
    }

    private static void test2() {
        Locale.setDefault(Locale.US);
        String string = "January 31, 2001";
        ParsePosition parsePosition = new ParsePosition(0);
        Calendar calendar = new BritishCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M d, y");
        calendar = simpleDateFormat.parse(string, calendar, parsePosition);
        System.out.println(string + " " + calendar.toString());
    }

    private static void test3() {
        Locale.setDefault(Locale.US);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2001, 1, 31);
        ChineseCalendar chineseCalendar = new ChineseCalendar(gregorianCalendar);
        String string = ((Calendar)chineseCalendar).toString();
        ParsePosition parsePosition = new ParsePosition(0);
        Calendar calendar = new ChineseCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("C-y-M-d-L");
        calendar = simpleDateFormat.parse(string, calendar, parsePosition);
        System.out.println("Gregorian " + ((Calendar)gregorianCalendar).toString() + " is Chinese " + calendar.toString());
    }
}

