/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.test;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.MayanCalendar;
import fi.joensuu.joyds1.calendar.format.DateParser;
import fi.joensuu.joyds1.calendar.format.DateParserException;
import java.util.Locale;
import java.util.Scanner;

public class TestDateParser {
    public static void main(String[] stringArray) {
        try {
            Scanner scanner = new Scanner("31. joulukuuta 2004");
            DateParser dateParser = DateParser.createFinnishDateParser(scanner);
            Calendar calendar = dateParser.parse();
            System.out.println(calendar.toString());
            scanner = new Scanner("30 November 2004");
            dateParser = DateParser.createEuropeanDateParser(new GregorianCalendar(), scanner, Locale.UK);
            calendar = dateParser.parse();
            System.out.println(calendar.toString());
            scanner = new Scanner("October 31, 2004");
            dateParser = DateParser.createUSDateParser(new GregorianCalendar(), scanner, Locale.US);
            calendar = dateParser.parse();
            System.out.println(calendar.toString());
            scanner = new Scanner("2004-01-31");
            dateParser = new DateParser(new GregorianCalendar(), scanner, DateParser.ISO, DateParser.What.YMD);
            calendar = dateParser.parse();
            System.out.println("Test ISO " + calendar.toString());
            scanner = new Scanner("20040131");
            dateParser = new DateParser(new GregorianCalendar(), scanner, DateParser.ISO_SHORT, DateParser.What.YMD);
            calendar = dateParser.parse();
            System.out.println("Test ISO_SHORT " + calendar.toString());
            scanner = new Scanner("1.2.3.4.5");
            dateParser = new DateParser(new MayanCalendar(), scanner, DateParser.MAYAN, DateParser.What.YMD);
            calendar = dateParser.parse();
            System.out.println("Test MAYAN " + calendar.toString());
            TestDateParser.test1("2004 January 21", DateParser.What.YMD);
            TestDateParser.test1("2004 22 January", DateParser.What.YDM);
            TestDateParser.test1("January 2004 23", DateParser.What.MYD);
            TestDateParser.test1("January 24 2004", DateParser.What.MDY);
            TestDateParser.test1("25 2004 January", DateParser.What.DYM);
            TestDateParser.test1("26 January 2004", DateParser.What.DMY);
            TestDateParser.test2("2004.12.31", DateParser.What.YMD);
            TestDateParser.test2("2004.31.12", DateParser.What.YDM);
            TestDateParser.test2("12.2004.31", DateParser.What.MYD);
            TestDateParser.test2("12.31.2004", DateParser.What.MDY);
            TestDateParser.test2("31.2004.12", DateParser.What.DYM);
            TestDateParser.test2("31.12.2004 1.12.2004", DateParser.What.DMY);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void test1(String string, DateParser.What what) throws DateParserException, Exception {
        Scanner scanner = new Scanner(string);
        DateParser dateParser = DateParser.createEuropeanDateParser(new GregorianCalendar(), scanner, Locale.UK, what);
        Calendar calendar = dateParser.parse();
        System.out.println("Test1 " + calendar.toString());
    }

    private static void test2(String string, DateParser.What what) throws DateParserException, Exception {
        Scanner scanner = new Scanner(string);
        DateParser dateParser = new DateParser(new GregorianCalendar(), scanner, DateParser.DOT, what);
        Calendar calendar = null;
        try {
            while ((calendar = dateParser.parse()) != null) {
                System.out.println("Test2 " + calendar.toString());
            }
        }
        catch (DateParserException dateParserException) {
            for (int i = 0; i < dateParserException.size(); ++i) {
                System.out.println(dateParserException.getParsed()[i]);
            }
        }
    }
}

