/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.test;

import fi.joensuu.joyds1.calendar.BritishCalendar;
import fi.joensuu.joyds1.calendar.BulgarianCalendar;
import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.DanishCalendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.HungarianCalendar;
import fi.joensuu.joyds1.calendar.PrussianCalendar;
import fi.joensuu.joyds1.calendar.SwissProtestantCalendar;
import fi.joensuu.joyds1.calendar.format.DateFormat;
import fi.joensuu.joyds1.calendar.format.SimpleDateFormat;

public class TestGregorianChangeover {
    private static final DateFormat f = new SimpleDateFormat("yyyy-MM-dd J");

    public static void main(String[] stringArray) {
        TestGregorianChangeover.test(new BritishCalendar(1752, 9, 1));
        TestGregorianChangeover.test(new BulgarianCalendar(1916, 3, 20));
        TestGregorianChangeover.test(new DanishCalendar(1700, 2, 1));
        TestGregorianChangeover.test(new GregorianCalendar(1582, 10, 1));
        TestGregorianChangeover.test(new HungarianCalendar(1587, 10, 1));
        TestGregorianChangeover.test(new PrussianCalendar(1610, 8, 1));
        TestGregorianChangeover.test(new SwissProtestantCalendar(1700, 12, 1));
    }

    private static void test(Calendar calendar) {
        System.out.println(calendar.getClass().getName());
        for (int i = 0; i < 60; ++i) {
            String string = f.format(calendar);
            if (!calendar.isDate(calendar.getYear(), calendar.getMonth(), calendar.getDay())) {
                System.out.println("bong " + string);
                System.exit(1);
            }
            int n = calendar.getDayOfYear();
            calendar.set(calendar.getYear(), n);
            String string2 = f.format(calendar);
            if (string.compareTo(string2) != 0) {
                System.out.println("Hups " + string + " " + string2 + " " + n);
                System.exit(1);
            }
            calendar.addDays(1);
        }
        System.out.println("");
    }
}

