/*
 * Decompiled with CFR 0.152.
 */
package jscicalc;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import jscicalc.AngleType;
import jscicalc.Base;
import jscicalc.CalculatorApplet;
import jscicalc.Notation;
import jscicalc.OObject;
import jscicalc.complex.Complex;

public class DataTransfer
extends AbstractAction
implements ClipboardOwner {
    private CalculatorApplet calculatorApplet;
    static final int maxLength = 120;
    static final int sigDigits = 32;
    private static final Pattern html = Pattern.compile("<html>");
    private static final Pattern htmlend = Pattern.compile("</html>");
    private static final Pattern minus = Pattern.compile("&#8722;");
    private static final long serialVersionUID = 1L;

    public DataTransfer(CalculatorApplet calculatorApplet) {
        this.calculatorApplet = calculatorApplet;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void copy() {
        OObject oObject = this.calculatorApplet.getValue();
        if (!(oObject instanceof Complex)) {
            return;
        }
        Complex complex = (Complex)oObject;
        Base base = this.calculatorApplet.getBase();
        Notation notation = new Notation();
        double d = 1.0;
        if (this.calculatorApplet.getAngleType() == AngleType.DEGREES) {
            d = 1.0;
        }
        String string = complex.toHTMLString(120, 32, base, notation, d);
        Matcher matcher = html.matcher(string);
        string = matcher.replaceAll("");
        matcher = htmlend.matcher(string);
        string = matcher.replaceAll("");
        matcher = minus.matcher(string);
        string = matcher.replaceAll("-");
        System.out.println(string);
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println(actionEvent.getActionCommand());
    }
}

