/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.complex;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Vector;
import jscicalc.Base;
import jscicalc.Notation;
import jscicalc.OObject;
import jscicalc.StringArray;
import jscicalc.complex.DoubleFormat;

public class Complex
extends OObject {
    private final double real_part;
    private final double imaginary_part;
    private static final Complex THIRD = new Complex(0.3333333333333333);
    private static final Complex LOG10 = new Complex(StrictMath.log(10.0));
    public static final Complex I = new Complex(0.0, 1.0);
    public static final double smallImaginary = 1.0E-10;

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double d) {
        this(d, 0.0);
    }

    public Complex(double d, double d2) {
        this.real_part = d;
        this.imaginary_part = d2;
    }

    public static Complex polar(double d, double d2) {
        return new Complex(d * StrictMath.cos(d2), d * StrictMath.cos(d2));
    }

    public boolean isZero() {
        return this.real() == 0.0 && this.imaginary() == 0.0;
    }

    public Long isInteger() {
        long l;
        if (this.imaginary() == 0.0 && (double)(l = (long)this.real()) == this.real()) {
            return l;
        }
        return null;
    }

    public boolean isNegative() {
        return this.real() < 0.0 || this.real() == 0.0 && this.imaginary() < 0.0;
    }

    public double real() {
        return this.real_part;
    }

    public double imaginary() {
        return this.imaginary_part;
    }

    public Complex conjugate() {
        return new Complex(this.real(), -this.imaginary());
    }

    public Complex negate() {
        return new Complex(-this.real(), -this.imaginary());
    }

    public double abs() {
        return StrictMath.hypot(this.real(), this.imaginary());
    }

    public double arg() {
        if (this.real() == 0.0 && this.imaginary() == 0.0) {
            return 0.0;
        }
        return StrictMath.atan2(this.imaginary(), this.real());
    }

    public Complex inverse() {
        if (this.real() == 0.0 && this.imaginary() == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (Double.isInfinite(this.real()) || Double.isInfinite(this.imaginary())) {
            Complex complex = new Complex(1.0, 0.0);
            return complex.divide(this);
        }
        BigDecimal bigDecimal = new BigDecimal(this.real());
        BigDecimal bigDecimal2 = new BigDecimal(this.imaginary());
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal).add(bigDecimal2.multiply(bigDecimal2));
        double d = bigDecimal.divide(bigDecimal3, MathContext.DECIMAL64).doubleValue();
        double d2 = bigDecimal2.negate().divide(bigDecimal3, MathContext.DECIMAL64).doubleValue();
        return new Complex(d, d2);
    }

    public Complex imultiply() {
        return new Complex(-this.imaginary(), this.real());
    }

    public Complex scale(double d) {
        return new Complex(d * this.real(), d * this.imaginary());
    }

    public Complex add(Complex complex) {
        return new Complex(this.real() + complex.real(), this.imaginary() + complex.imaginary());
    }

    public Complex subtract(Complex complex) {
        return new Complex(this.real() - complex.real(), this.imaginary() - complex.imaginary());
    }

    public Complex multiply(Complex complex) {
        if (Double.isInfinite(this.real()) || Double.isInfinite(this.imaginary()) || Double.isInfinite(complex.real()) || Double.isInfinite(complex.imaginary())) {
            double d = this.real();
            double d2 = this.imaginary();
            double d3 = complex.real();
            double d4 = complex.imaginary();
            double d5 = d * d3;
            double d6 = d2 * d4;
            double d7 = d * d4;
            double d8 = d2 * d3;
            if (Double.isNaN(d5) && (d == 0.0 || d3 == 0.0)) {
                d5 = 0.0;
            }
            if (Double.isNaN(d6) && (d2 == 0.0 || d4 == 0.0)) {
                d6 = 0.0;
            }
            if (Double.isNaN(d7) && (d == 0.0 || d4 == 0.0)) {
                d7 = 0.0;
            }
            if (Double.isNaN(d8) && (d2 == 0.0 || d3 == 0.0)) {
                d8 = 0.0;
            }
            double d9 = d5 - d6;
            double d10 = d8 + d7;
            if (d9 == 0.0 && d10 == 0.0) {
                return new Complex(Double.NaN, Double.NaN);
            }
            return new Complex(d9, d10);
        }
        if (Double.isNaN(this.real()) || Double.isNaN(this.imaginary()) || Double.isNaN(complex.real()) || Double.isNaN(complex.imaginary())) {
            return new Complex(Double.NaN, Double.NaN);
        }
        BigDecimal bigDecimal = new BigDecimal(this.real());
        BigDecimal bigDecimal2 = new BigDecimal(this.imaginary());
        BigDecimal bigDecimal3 = new BigDecimal(complex.real());
        BigDecimal bigDecimal4 = new BigDecimal(complex.imaginary());
        double d = bigDecimal.multiply(bigDecimal3).subtract(bigDecimal2.multiply(bigDecimal4)).doubleValue();
        double d11 = bigDecimal.multiply(bigDecimal4).add(bigDecimal2.multiply(bigDecimal3)).doubleValue();
        return new Complex(d, d11);
    }

    public Complex divide(Complex complex) {
        if (complex.real() == 0.0 && complex.imaginary() == 0.0) {
            if (this.real() == 0.0 && this.imaginary() == 0.0) {
                return new Complex(Double.NaN);
            }
            double d = 0.0;
            if (this.real() > 0.0) {
                d = Double.POSITIVE_INFINITY;
            } else if (this.real() < 0.0) {
                d = Double.NEGATIVE_INFINITY;
            }
            double d2 = 0.0;
            if (this.imaginary() > 0.0) {
                d2 = Double.POSITIVE_INFINITY;
            } else if (this.imaginary() < 0.0) {
                d2 = Double.NEGATIVE_INFINITY;
            }
            return new Complex(d, d2);
        }
        double d = complex.real() * complex.real() + complex.imaginary() * complex.imaginary();
        if (Double.isNaN(d)) {
            return new Complex(Double.NaN, Double.NaN);
        }
        if (Double.isInfinite(d)) {
            if (this.real() == 0.0 && this.imaginary() == 0.0) {
                return new Complex(Double.NaN, Double.NaN);
            }
            return new Complex();
        }
        BigDecimal bigDecimal = new BigDecimal(this.real());
        BigDecimal bigDecimal2 = new BigDecimal(this.imaginary());
        BigDecimal bigDecimal3 = new BigDecimal(complex.real());
        BigDecimal bigDecimal4 = new BigDecimal(complex.imaginary());
        BigDecimal bigDecimal5 = bigDecimal3.multiply(bigDecimal3).add(bigDecimal4.multiply(bigDecimal4));
        double d3 = bigDecimal.multiply(bigDecimal3).add(bigDecimal2.multiply(bigDecimal4)).divide(bigDecimal5, MathContext.DECIMAL64).doubleValue();
        double d4 = bigDecimal2.multiply(bigDecimal3).subtract(bigDecimal.multiply(bigDecimal4)).divide(bigDecimal5, MathContext.DECIMAL64).doubleValue();
        return new Complex(d3, d4);
    }

    public Complex square() {
        return this.multiply(this);
    }

    public Complex cube() {
        return this.multiply(this.square());
    }

    public Complex sqrt() {
        double d;
        if (this.real() == 0.0 && this.imaginary() == 0.0) {
            return new Complex();
        }
        double d2 = StrictMath.abs(this.real());
        double d3 = StrictMath.abs(this.imaginary());
        double d4 = 0.0;
        if (d2 >= d3) {
            d = d3 / d2;
            d4 = StrictMath.sqrt(d2) * StrictMath.sqrt(0.5 * (1.0 + StrictMath.sqrt(1.0 + d * d)));
        } else {
            d = d2 / d3;
            d4 = StrictMath.sqrt(d3) * StrictMath.sqrt(0.5 * (d + StrictMath.sqrt(1.0 + d * d)));
        }
        if (this.real() >= 0.0) {
            return new Complex(d4, this.imaginary() / (2.0 * d4));
        }
        d = this.imaginary() >= 0.0 ? d4 : -d4;
        return new Complex(this.imaginary() / (2.0 * d), d);
    }

    public Complex exp() {
        double d = StrictMath.exp(this.real());
        double d2 = this.imaginary();
        return new Complex(d * StrictMath.cos(d2), d * StrictMath.sin(d2));
    }

    public Complex tenx() {
        return this.multiply(LOG10).exp();
    }

    private double logabs() {
        double d;
        double d2;
        double d3;
        double d4 = StrictMath.abs(this.real());
        if (d4 >= (d3 = StrictMath.abs(this.imaginary()))) {
            d2 = d4;
            d = d3 / d4;
        } else {
            d2 = d3;
            d = d4 / d3;
        }
        return StrictMath.log(d2) + 0.5 * StrictMath.log1p(d * d);
    }

    private Complex pow(int n) {
        Complex complex = new Complex(this.real(), this.imaginary());
        Complex complex2 = new Complex(1.0, 0.0);
        boolean bl = false;
        while (n > 0) {
            if (n % 2 == 1) {
                if (bl) {
                    complex2 = complex2.multiply(complex);
                } else {
                    bl = true;
                    complex2 = new Complex(complex.real(), complex.imaginary());
                }
            }
            n /= 2;
            complex = complex.square();
        }
        return complex2;
    }

    private Complex root(int n) {
        if (n == 2) {
            return this.sqrt();
        }
        double d = this.logabs();
        double d2 = this.arg();
        double d3 = StrictMath.exp(d / (double)n);
        double d4 = d2 / (double)n;
        Complex complex = new Complex(d3 * StrictMath.cos(d4), d3 * StrictMath.sin(d4));
        double d5 = 1.0;
        for (int i = 0; d5 > 2.220446049250313E-16 && i < 10; ++i) {
            Complex complex2 = complex.scale(n - 1).add(this.divide(complex.pow(n - 1)));
            complex2 = complex2.scale(1.0 / (double)n);
            d5 = this.subtract(complex2.pow(n)).abs() + complex2.subtract(complex).abs();
            complex = new Complex(complex2.real(), complex2.imaginary());
        }
        return complex;
    }

    public Complex pow(Complex complex) {
        if (this.real() == 0.0 && this.imaginary() == 0.0) {
            if (complex.real() == 0.0 && complex.imaginary() == 0.0) {
                return new Complex(1.0, 0.0);
            }
            return new Complex();
        }
        if (complex.imaginary() == 0.0) {
            int n = (int)complex.real();
            if (complex.real() == (double)n) {
                if (n > 0) {
                    return this.pow(n);
                }
                return this.pow(-n).inverse();
            }
        }
        double d = this.logabs();
        double d2 = this.arg();
        double d3 = complex.real();
        double d4 = complex.imaginary();
        double d5 = StrictMath.exp(d * d3 - d4 * d2);
        double d6 = d2 * d3 + d4 * d;
        return new Complex(d5 * StrictMath.cos(d6), d5 * StrictMath.sin(d6));
    }

    public Complex root(Complex complex) {
        if (complex.imaginary() == 0.0) {
            if (complex.real() == 0.0) {
                if (this.arg() != 0.0) {
                    return new Complex(Double.NaN, Double.NaN);
                }
                if (this.abs() == 1.0) {
                    return new Complex(1.0, 0.0);
                }
                if (this.abs() < 1.0) {
                    return new Complex(0.0, 0.0);
                }
                if (this.abs() > 1.0) {
                    return new Complex(Double.POSITIVE_INFINITY, 0.0);
                }
                return null;
            }
            int n = (int)complex.real();
            if (complex.real() == (double)n) {
                if (n > 0) {
                    return this.root(n);
                }
                return this.root(n).inverse();
            }
        }
        return this.pow(complex.inverse());
    }

    public Complex log() {
        double d = this.logabs();
        double d2 = this.arg();
        return new Complex(d, d2);
    }

    public Complex log10() {
        double d = 1.0 / StrictMath.log(10.0);
        return this.log().scale(d);
    }

    public Complex cuberoot() {
        return this.root(3);
    }

    public Complex sin() {
        double d = this.real();
        double d2 = this.imaginary();
        if (d2 == 0.0) {
            return new Complex(StrictMath.sin(d), 0.0);
        }
        return new Complex(StrictMath.sin(d) * StrictMath.cosh(d2), StrictMath.cos(d) * StrictMath.sinh(d2));
    }

    public Complex cos() {
        double d = this.real();
        double d2 = this.imaginary();
        if (d2 == 0.0) {
            return new Complex(StrictMath.cos(d), 0.0);
        }
        return new Complex(StrictMath.cos(d) * StrictMath.cosh(d2), StrictMath.sin(d) * StrictMath.sinh(-d2));
    }

    public Complex tan() {
        double d = this.real();
        double d2 = this.imaginary();
        if (d2 == 0.0) {
            double d3 = 2.0 * d - Math.PI;
            long l = StrictMath.round(d3 / Math.PI);
            if (l % 2L == 0L && d3 == (double)l * Math.PI) {
                return new Complex(Double.NaN, Double.NaN);
            }
            return new Complex(StrictMath.tan(d), 0.0);
        }
        if (StrictMath.abs(d2) < 1.0) {
            double d4 = StrictMath.cos(d);
            double d5 = StrictMath.sinh(d2);
            double d6 = d4 * d4 + d5 * d5;
            return new Complex(0.5 * StrictMath.sin(2.0 * d) / d6, 0.5 * StrictMath.sinh(2.0 * d2) / d6);
        }
        double d7 = StrictMath.exp(-d2);
        double d8 = 2.0 * d7 / (1.0 - d7 * d7);
        double d9 = StrictMath.cos(d);
        double d10 = d8 * d8;
        double d11 = 1.0 + d9 * d9 * d10;
        double d12 = 1.0 / StrictMath.tanh(d2);
        return new Complex(0.5 * StrictMath.sin(2.0 * d) * d10 / d11, d12 / d11);
    }

    private double acosh_real(double d) {
        return StrictMath.log(d + StrictMath.sqrt(d * d - 1.0));
    }

    private Complex asin_real(double d) {
        if (StrictMath.abs(d) <= 1.0) {
            return new Complex(StrictMath.asin(d), 0.0);
        }
        if (d < 0.0) {
            return new Complex(-1.5707963267948966, this.acosh_real(-d));
        }
        return new Complex(1.5707963267948966, -this.acosh_real(d));
    }

    public Complex asin() {
        double d;
        double d2;
        double d3;
        double d4 = this.real();
        double d5 = this.imaginary();
        if (d5 == 0.0) {
            return this.asin_real(d4);
        }
        double d6 = StrictMath.abs(d4);
        double d7 = StrictMath.abs(d5);
        double d8 = StrictMath.hypot(d6 + 1.0, d7);
        double d9 = StrictMath.hypot(d6 - 1.0, d7);
        double d10 = 0.5 * (d8 + d9);
        double d11 = d6 / d10;
        double d12 = d7 * d7;
        if (d11 <= 0.6417) {
            d3 = StrictMath.asin(d11);
        } else if (d6 <= 1.0) {
            d2 = 0.5 * (d10 + d6) * (d12 / (d8 + d6 + 1.0) + (d9 + (1.0 - d6)));
            d3 = StrictMath.atan(d6 / StrictMath.sqrt(d2));
        } else {
            d2 = d10 + d6;
            double d13 = 0.5 * (d2 / (d8 + d6 + 1.0) + d2 / (d9 + (d6 - 1.0)));
            d3 = StrictMath.atan(d6 / (d7 * StrictMath.sqrt(d13)));
        }
        if (d10 <= 1.5) {
            d2 = d6 < 1.0 ? 0.5 * (d12 / (d8 + (d6 + 1.0)) + d12 / (d9 + (1.0 - d6))) : 0.5 * (d12 / (d8 + (d6 + 1.0)) + (d9 + (d6 - 1.0)));
            d = StrictMath.log1p(d2 + StrictMath.sqrt(d2 * (d10 + 1.0)));
        } else {
            d = StrictMath.log(d10 + StrictMath.sqrt(d10 * d10 - 1.0));
        }
        return new Complex(d4 >= 0.0 ? d3 : -d3, d5 >= 0.0 ? d : -d);
    }

    private Complex acos_real(double d) {
        if (StrictMath.abs(d) <= 1.0) {
            return new Complex(StrictMath.acos(d), 0.0);
        }
        if (d < 0.0) {
            return new Complex(Math.PI, -this.acosh_real(-d));
        }
        return new Complex(0.0, this.acosh_real(d));
    }

    public Complex acos() {
        double d;
        double d2;
        double d3;
        double d4 = this.real();
        double d5 = this.imaginary();
        if (d5 == 0.0) {
            return this.acos_real(d4);
        }
        double d6 = StrictMath.abs(d4);
        double d7 = StrictMath.abs(d5);
        double d8 = StrictMath.hypot(d6 + 1.0, d7);
        double d9 = StrictMath.hypot(d6 - 1.0, d7);
        double d10 = 0.5 * (d8 + d9);
        double d11 = d6 / d10;
        double d12 = d7 * d7;
        if (d11 <= 0.6417) {
            d3 = StrictMath.acos(d11);
        } else if (d6 <= 1.0) {
            d2 = 0.5 * (d10 + d6) * (d12 / (d8 + d6 + 1.0) + (d9 + (1.0 - d6)));
            d3 = StrictMath.atan(StrictMath.sqrt(d2) / d6);
        } else {
            d2 = d10 + d6;
            double d13 = 0.5 * (d2 / (d8 + d6 + 1.0) + d2 / (d9 + (d6 - 1.0)));
            d3 = StrictMath.atan(d7 * StrictMath.sqrt(d13) / d6);
        }
        if (d10 <= 1.5) {
            d2 = d6 < 1.0 ? 0.5 * (d12 / (d8 + (d6 + 1.0)) + d12 / (d9 + (1.0 - d6))) : 0.5 * (d12 / (d8 + (d6 + 1.0)) + (d9 + (d6 - 1.0)));
            d = StrictMath.log1p(d2 + StrictMath.sqrt(d2 * (d10 + 1.0)));
        } else {
            d = StrictMath.log(d10 + StrictMath.sqrt(d10 * d10 - 1.0));
        }
        return new Complex(d4 >= 0.0 ? d3 : Math.PI - d3, d5 >= 0.0 ? -d : d);
    }

    public Complex atan() {
        double d;
        double d2 = this.real();
        double d3 = this.imaginary();
        if (d3 == 0.0) {
            return new Complex(StrictMath.atan(d2), 0.0);
        }
        double d4 = StrictMath.hypot(d2, d3);
        double d5 = 2.0 * d3 / (1.0 + d4 * d4);
        if (StrictMath.abs(d5) < 0.1) {
            d = 0.25 * (StrictMath.log1p(d5) - StrictMath.log1p(-d5));
        } else {
            double d6 = StrictMath.hypot(d2, d3 + 1.0);
            double d7 = StrictMath.hypot(d2, d3 - 1.0);
            d = 0.5 * StrictMath.log(d6 / d7);
        }
        if (d2 == 0.0) {
            if (d3 > 1.0) {
                return new Complex(1.5707963267948966, d);
            }
            if (d3 < -1.0) {
                return new Complex(-1.5707963267948966, d);
            }
            return new Complex(0.0, d);
        }
        return new Complex(0.5 * StrictMath.atan2(2.0 * d2, (1.0 + d4) * (1.0 - d4)), d);
    }

    public Complex and(Complex complex) {
        return new Complex(Complex.and(this.real(), complex.real()), Complex.and(this.imaginary(), complex.imaginary()));
    }

    private static double and(double d, double d2) {
        long l;
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isInfinite(d) || Double.isInfinite(d2)) {
            throw new RuntimeException("Boolean Error");
        }
        if (StrictMath.abs(d2) > StrictMath.abs(d)) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        boolean bl = (l = Double.doubleToLongBits(d)) >> 63 == 0L;
        int n = (int)(l >> 52 & 0x7FFL);
        long l2 = n == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        long l3 = Double.doubleToLongBits(d2);
        boolean bl2 = l3 >> 63 == 0L;
        int n2 = (int)(l3 >> 52 & 0x7FFL);
        long l4 = n2 == 0 ? (l3 & 0xFFFFFFFFFFFFFL) << 1 : l3 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        l2 &= (l4 >>= n - n2);
        if (n == 0) {
            l2 >>= 1;
        } else {
            if (l2 == 0L) {
                return 0.0;
            }
            while ((l2 & 0x10000000000000L) == 0L) {
                l2 <<= 1;
                if (--n != 0) continue;
                l2 >>= 1;
                break;
            }
            l2 &= 0xFFFFFFFFFFFFFL;
        }
        l = (long)n << 52;
        double d4 = Double.longBitsToDouble(l |= l2);
        if (!bl & !bl2) {
            d4 = -d4;
        }
        return d4;
    }

    public Complex or(Complex complex) {
        return new Complex(Complex.or(this.real(), complex.real()), Complex.or(this.imaginary(), complex.imaginary()));
    }

    public static double or(double d, double d2) {
        long l;
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isInfinite(d) || Double.isInfinite(d2)) {
            throw new RuntimeException("Boolean Error");
        }
        if (StrictMath.abs(d2) > StrictMath.abs(d)) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        boolean bl = (l = Double.doubleToLongBits(d)) >> 63 == 0L;
        int n = (int)(l >> 52 & 0x7FFL);
        long l2 = n == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        long l3 = Double.doubleToLongBits(d2);
        boolean bl2 = l3 >> 63 == 0L;
        int n2 = (int)(l3 >> 52 & 0x7FFL);
        long l4 = n2 == 0 ? (l3 & 0xFFFFFFFFFFFFFL) << 1 : l3 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        l2 |= (l4 >>= n - n2);
        if (n == 0) {
            l2 >>= 1;
        } else {
            if (l2 == 0L) {
                return 0.0;
            }
            while ((l2 & 0x10000000000000L) == 0L) {
                l2 <<= 1;
                if (--n != 0) continue;
                l2 >>= 1;
                break;
            }
            l2 &= 0xFFFFFFFFFFFFFL;
        }
        l = (long)n << 52;
        double d4 = Double.longBitsToDouble(l |= l2);
        if (!bl | !bl2) {
            d4 = -d4;
        }
        return d4;
    }

    public Complex xor(Complex complex) {
        return new Complex(this.xor(this.real(), complex.real()), this.xor(this.imaginary(), complex.imaginary()));
    }

    public double xor(double d, double d2) {
        long l;
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isInfinite(d) || Double.isInfinite(d2)) {
            throw new RuntimeException("Boolean Error");
        }
        if (StrictMath.abs(d2) > StrictMath.abs(d)) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        boolean bl = (l = Double.doubleToLongBits(d)) >> 63 == 0L;
        int n = (int)(l >> 52 & 0x7FFL);
        long l2 = n == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        long l3 = Double.doubleToLongBits(d2);
        boolean bl2 = l3 >> 63 == 0L;
        int n2 = (int)(l3 >> 52 & 0x7FFL);
        long l4 = n2 == 0 ? (l3 & 0xFFFFFFFFFFFFFL) << 1 : l3 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        l2 ^= (l4 >>= n - n2);
        if (n == 0) {
            l2 >>= 1;
        } else {
            if (l2 == 0L) {
                return 0.0;
            }
            while ((l2 & 0x10000000000000L) == 0L) {
                l2 <<= 1;
                if (--n != 0) continue;
                l2 >>= 1;
                break;
            }
            l2 &= 0xFFFFFFFFFFFFFL;
        }
        l = (long)n << 52;
        double d4 = Double.longBitsToDouble(l |= l2);
        if (bl ^ bl2) {
            d4 = -d4;
        }
        return d4;
    }

    public Complex factorial() {
        double d = this.real();
        if (this.imaginary() != 0.0 || d < 0.0 || (double)StrictMath.round(d) - d != 0.0) {
            throw new ArithmeticException("Factorial error");
        }
        if (d > 1024.0) {
            return new Complex(Double.POSITIVE_INFINITY);
        }
        try {
            return new Complex(Complex.factorial(StrictMath.round(d)), 0.0);
        }
        catch (Exception exception) {
            throw new ArithmeticException("Factorial error");
        }
    }

    private static double factorial(long l) {
        if (l == 0L) {
            return 1.0;
        }
        return (double)l * Complex.factorial(l - 1L);
    }

    public Complex combination(Complex complex) {
        double d = this.real();
        double d2 = complex.real();
        if (this.imaginary() != 0.0 || d < 0.0 || (double)StrictMath.round(d) - d != 0.0) {
            throw new ArithmeticException("Combination error");
        }
        if (complex.imaginary() != 0.0 || d2 < 0.0 || d2 > d || (double)StrictMath.round(d2) - d2 != 0.0) {
            throw new ArithmeticException("Combination error");
        }
        try {
            return new Complex(Complex.combination(StrictMath.round(d), StrictMath.round(d2)), 0.0);
        }
        catch (Exception exception) {
            throw new ArithmeticException("Combination error");
        }
    }

    private static double combination(long l, long l2) {
        if (l2 == 0L) {
            return 1.0;
        }
        return (double)l / (double)l2 * Complex.combination(l - 1L, l2 - 1L);
    }

    public Complex permutation(Complex complex) {
        double d = this.real();
        double d2 = complex.real();
        if (this.imaginary() != 0.0 || d < 0.0 || (double)StrictMath.round(d) - d != 0.0) {
            throw new ArithmeticException("Combination error");
        }
        if (complex.imaginary() != 0.0 || d2 < 0.0 || d2 > d || (double)StrictMath.round(d2) - d2 != 0.0) {
            throw new ArithmeticException("Combination error");
        }
        try {
            return new Complex(Complex.permutation(StrictMath.round(d), StrictMath.round(d2)), 0.0);
        }
        catch (Exception exception) {
            throw new ArithmeticException("Permutation error");
        }
    }

    private static double permutation(long l, long l2) {
        if (l2 == 0L) {
            return 1.0;
        }
        return (double)l * Complex.permutation(l - 1L, l2 - 1L);
    }

    public StringArray toHTMLSubString(int n, int n2, Base base, Notation notation, double d) {
        StringArray stringArray = new StringArray();
        if (Double.isNaN(this.real()) || Double.isNaN(this.imaginary())) {
            String[] stringArray2 = new String[]{"E", "r", "r", "o", "r"};
            stringArray.add(stringArray2);
            return stringArray;
        }
        if (n < 4) {
            throw new RuntimeException("Complex.toHTMLSubStringmaxChars must be at least four");
        }
        if (n2 < 1) {
            throw new RuntimeException("Complex.toHTMLSubStringprecision must be positive");
        }
        Notation notation2 = new Notation();
        if (notation.standard()) {
            notation2.setStandard();
        } else {
            notation2.setScientific();
        }
        if (notation.complex()) {
            notation2.setComplex();
        } else {
            notation2.setNonComplex();
        }
        if (notation.rectangular()) {
            notation2.setRectangular();
        } else {
            notation2.setPolar();
        }
        if (notation2.standard() && (stringArray = this.tryHTMLString((int)n, (int)n2, (Base)base, (Notation)notation2).stringVector) != null) {
            return stringArray;
        }
        notation2.setScientific();
        stringArray = this.tryHTMLString((int)n, (int)n2, (Base)base, (Notation)notation2).stringVector;
        if (stringArray != null) {
            return stringArray;
        }
        stringArray = new StringArray();
        String[] stringArray3 = new String[]{"O", "v", "e", "r", "f", "l", "o", "w"};
        stringArray.add(stringArray3);
        return stringArray;
    }

    public StringArray toHTMLParenString(int n, int n2, Base base, Notation notation, double d) {
        HTMLStringResult hTMLStringResult;
        StringArray stringArray = new StringArray();
        if (Double.isNaN(this.real()) || Double.isNaN(this.imaginary())) {
            String[] stringArray2 = new String[]{"E", "r", "r", "o", "r"};
            stringArray.add(stringArray2);
            return stringArray;
        }
        if (n < 4) {
            throw new RuntimeException("Complex.toHTMLParenStringmaxChars must be at least four");
        }
        if (n2 < 1) {
            throw new RuntimeException("Complex.toHTMLParenStringprecision must be positive");
        }
        Notation notation2 = new Notation();
        if (notation.standard()) {
            notation2.setStandard();
        } else {
            notation2.setScientific();
        }
        if (notation.complex()) {
            notation2.setComplex();
        } else {
            notation2.setNonComplex();
        }
        if (notation.rectangular()) {
            notation2.setRectangular();
        } else {
            notation2.setPolar();
        }
        if (notation2.standard()) {
            hTMLStringResult = this.tryHTMLString(n, n2, base, notation2);
            if (hTMLStringResult.stringVector != null) {
                if (hTMLStringResult.parentheses.booleanValue()) {
                    stringArray.add("(");
                    stringArray.addAll(hTMLStringResult.stringVector);
                    stringArray.add(")");
                    return stringArray;
                }
                return hTMLStringResult.stringVector;
            }
        }
        notation2.setScientific();
        hTMLStringResult = this.tryHTMLString(n, n2, base, notation2);
        if (hTMLStringResult.stringVector != null) {
            if (hTMLStringResult.parentheses.booleanValue()) {
                stringArray.add("(");
                stringArray.addAll(hTMLStringResult.stringVector);
                stringArray.add(")");
                return stringArray;
            }
            return hTMLStringResult.stringVector;
        }
        String[] stringArray3 = new String[]{"O", "v", "e", "r", "f", "l", "o", "w"};
        stringArray.add(stringArray3);
        return stringArray;
    }

    private HTMLStringResult tryHTMLString(int n, int n2, Base base, Notation notation) {
        DoubleFormat doubleFormat;
        DoubleFormat doubleFormat2;
        HTMLStringResult hTMLStringResult = new HTMLStringResult();
        Notation notation2 = new Notation();
        Notation notation3 = new Notation();
        if (notation.rectangular()) {
            doubleFormat2 = new DoubleFormat(this.real(), base);
            doubleFormat = new DoubleFormat(this.imaginary(), base);
            if (notation.scientific()) {
                notation2.setScientific();
                notation3.setScientific();
            }
        } else {
            doubleFormat2 = new DoubleFormat(this.abs(), base);
            doubleFormat = new DoubleFormat(this.arg(), base);
            if (notation.scientific()) {
                notation2.setScientific();
            }
        }
        doubleFormat2.setNotation(notation2);
        doubleFormat.setNotation(notation3);
        int n3 = n2;
        int n4 = n2;
        while (n4 > 0) {
            DoubleFormat.HTMLStringRepresentation hTMLStringRepresentation = doubleFormat2.NullRepresentation;
            DoubleFormat.HTMLStringRepresentation hTMLStringRepresentation2 = doubleFormat.NullRepresentation;
            if (notation.complex() || doubleFormat.getAbsNumber() > 1.0E-10) {
                doubleFormat.setPrecision(n4);
                hTMLStringRepresentation2 = doubleFormat.representation();
            }
            if (hTMLStringRepresentation2 == doubleFormat.NullRepresentation || notation.complex() || doubleFormat2.getAbsNumber() != (double)(!notation.rectangular() ? 1 : 0) || notation.polar() && notation.scientific()) {
                doubleFormat2.setPrecision(n3);
                hTMLStringRepresentation = doubleFormat2.representation();
            }
            int n5 = hTMLStringRepresentation.length + hTMLStringRepresentation2.length;
            if (notation.rectangular()) {
                if (hTMLStringRepresentation != doubleFormat2.NullRepresentation && hTMLStringRepresentation2 != doubleFormat.NullRepresentation && this.imaginary() >= 0.0) {
                    ++n5;
                }
                if (hTMLStringRepresentation2 != doubleFormat.NullRepresentation) {
                    ++n5;
                }
                if (hTMLStringRepresentation2.isOne() || hTMLStringRepresentation2.isMinusOne()) {
                    --n5;
                }
            } else {
                if (hTMLStringRepresentation2 != doubleFormat.NullRepresentation) {
                    ++n5;
                    ++n5;
                }
                if (hTMLStringRepresentation2.isOne() || hTMLStringRepresentation2.isMinusOne()) {
                    --n5;
                }
            }
            if (n5 <= n) {
                StringArray stringArray = new StringArray();
                stringArray.addAll(hTMLStringRepresentation.string);
                if (notation.rectangular()) {
                    if (hTMLStringRepresentation != doubleFormat2.NullRepresentation && hTMLStringRepresentation2 != doubleFormat.NullRepresentation) {
                        hTMLStringResult.parentheses = true;
                        if (this.imaginary() >= 0.0) {
                            stringArray.add(DoubleFormat.plus);
                        }
                    }
                } else if (hTMLStringRepresentation2 != doubleFormat.NullRepresentation) {
                    stringArray.add(DoubleFormat.argumentPrefix);
                    ((Vector)stringArray.lastElement()).setElementAt(((String)((Vector)stringArray.lastElement()).lastElement()).concat("<sup style=\"font-size:60%;\">"), ((Vector)stringArray.lastElement()).size() - 1);
                }
                if (!hTMLStringRepresentation2.string.equals("1")) {
                    if (hTMLStringRepresentation2.isMinusOne()) {
                        stringArray.add(DoubleFormat.minus);
                    } else {
                        stringArray.addAll(hTMLStringRepresentation2.string);
                    }
                }
                if (notation.rectangular()) {
                    if (hTMLStringRepresentation2 != doubleFormat.NullRepresentation) {
                        stringArray.add(DoubleFormat.imPrefix);
                    }
                } else if (hTMLStringRepresentation2 != doubleFormat.NullRepresentation) {
                    stringArray.add(DoubleFormat.imPrefix);
                    ((Vector)stringArray.lastElement()).setElementAt(((String)((Vector)stringArray.lastElement()).lastElement()).concat("</sup>"), ((Vector)stringArray.lastElement()).size() - 1);
                }
                hTMLStringResult.stringVector = new StringArray();
                hTMLStringResult.stringVector.addAll(stringArray);
                return hTMLStringResult;
            }
            if (n3 == n4) {
                --n4;
                continue;
            }
            --n3;
        }
        return hTMLStringResult;
    }

    private static int min(int n, int n2) {
        return n > n2 ? n2 : n;
    }

    public int compareTo(Complex complex) {
        double d;
        double d2 = this.abs();
        if (d2 < (d = complex.abs())) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        d2 = this.arg();
        if (d2 > (d = complex.arg())) {
            return -1;
        }
        if (d2 < d) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        Complex complex = new Complex(243.0, 0.0);
        Complex complex2 = complex.root(37);
        System.out.print(complex2.real());
        System.out.print("+");
        System.out.print(complex2.imaginary());
        System.out.println("i");
    }

    private class HTMLStringResult {
        public StringArray stringVector = null;
        public Boolean parentheses = false;

        HTMLStringResult() {
        }
    }
}

